// Template Source: BaseMethodCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AccessPackageAssignmentFilterByCurrentUserOptions;
import com.microsoft.graph.models.AccessPackageAssignment;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.AccessPackageAssignmentFilterByCurrentUserCollectionRequestBuilder;
import com.microsoft.graph.requests.AccessPackageAssignmentFilterByCurrentUserCollectionRequest;
import com.microsoft.graph.requests.AccessPackageAssignmentFilterByCurrentUserCollectionResponse;
import com.microsoft.graph.models.AccessPackageAssignmentFilterByCurrentUserParameterSet;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseFunctionCollectionRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Package Assignment Filter By Current User Collection Request Builder.
 */
public class AccessPackageAssignmentFilterByCurrentUserCollectionRequestBuilder extends BaseFunctionCollectionRequestBuilder<AccessPackageAssignment, AccessPackageAssignmentFilterByCurrentUserCollectionRequestBuilder, AccessPackageAssignmentFilterByCurrentUserCollectionResponse, AccessPackageAssignmentFilterByCurrentUserCollectionPage, AccessPackageAssignmentFilterByCurrentUserCollectionRequest> {

    /**
     * The request builder for this collection of AccessPackageAssignment
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AccessPackageAssignmentFilterByCurrentUserCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AccessPackageAssignmentFilterByCurrentUserCollectionRequestBuilder.class, AccessPackageAssignmentFilterByCurrentUserCollectionRequest.class);
    }
    /**
     * The request builder for this collection of AccessPackageAssignment
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public AccessPackageAssignmentFilterByCurrentUserCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final AccessPackageAssignmentFilterByCurrentUserParameterSet parameters) {
        super(requestUrl, client, requestOptions, AccessPackageAssignmentFilterByCurrentUserCollectionRequestBuilder.class, AccessPackageAssignmentFilterByCurrentUserCollectionRequest.class);
        if(parameters != null) {
            functionOptions = parameters.getFunctionOptions();
        }
    }
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the AccessPackageAssignmentFilterByCurrentUserCollectionRequest instance
     */
    @Override
    @Nonnull
    public AccessPackageAssignmentFilterByCurrentUserCollectionRequest buildRequest(@Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final AccessPackageAssignmentFilterByCurrentUserCollectionRequest request = super.buildRequest(requestOptions);
        if(functionOptions != null) {    
            for (com.microsoft.graph.options.FunctionOption option : functionOptions) {
                request.addFunctionOption(option);
            }
        }
        return request;
    }
}
