// Template Source: BaseMethodCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AccessReviewStageFilterByCurrentUserOptions;
import com.microsoft.graph.models.AccessReviewStage;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.AccessReviewStageFilterByCurrentUserCollectionRequestBuilder;
import com.microsoft.graph.requests.AccessReviewStageFilterByCurrentUserCollectionRequest;
import com.microsoft.graph.requests.AccessReviewStageFilterByCurrentUserCollectionResponse;
import com.microsoft.graph.models.AccessReviewStageFilterByCurrentUserParameterSet;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseFunctionCollectionRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Review Stage Filter By Current User Collection Request Builder.
 */
public class AccessReviewStageFilterByCurrentUserCollectionRequestBuilder extends BaseFunctionCollectionRequestBuilder<AccessReviewStage, AccessReviewStageFilterByCurrentUserCollectionRequestBuilder, AccessReviewStageFilterByCurrentUserCollectionResponse, AccessReviewStageFilterByCurrentUserCollectionPage, AccessReviewStageFilterByCurrentUserCollectionRequest> {

    /**
     * The request builder for this collection of AccessReviewStage
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AccessReviewStageFilterByCurrentUserCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AccessReviewStageFilterByCurrentUserCollectionRequestBuilder.class, AccessReviewStageFilterByCurrentUserCollectionRequest.class);
    }
    /**
     * The request builder for this collection of AccessReviewStage
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public AccessReviewStageFilterByCurrentUserCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final AccessReviewStageFilterByCurrentUserParameterSet parameters) {
        super(requestUrl, client, requestOptions, AccessReviewStageFilterByCurrentUserCollectionRequestBuilder.class, AccessReviewStageFilterByCurrentUserCollectionRequest.class);
        if(parameters != null) {
            functionOptions = parameters.getFunctionOptions();
        }
    }
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the AccessReviewStageFilterByCurrentUserCollectionRequest instance
     */
    @Override
    @Nonnull
    public AccessReviewStageFilterByCurrentUserCollectionRequest buildRequest(@Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final AccessReviewStageFilterByCurrentUserCollectionRequest request = super.buildRequest(requestOptions);
        if(functionOptions != null) {    
            for (com.microsoft.graph.options.FunctionOption option : functionOptions) {
                request.addFunctionOption(option);
            }
        }
        return request;
    }
}
