// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AndroidLobApp;
import com.microsoft.graph.models.MobileAppAssignment;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Android Lob App Request.
 */
public class AndroidLobAppRequest extends BaseRequest<AndroidLobApp> {
	
    /**
     * The request for the AndroidLobApp
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AndroidLobAppRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AndroidLobApp.class);
    }

    /**
     * Gets the AndroidLobApp from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AndroidLobApp> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AndroidLobApp from the service
     *
     * @return the AndroidLobApp from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AndroidLobApp get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AndroidLobApp> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AndroidLobApp delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AndroidLobApp with a source
     *
     * @param sourceAndroidLobApp the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AndroidLobApp> patchAsync(@Nonnull final AndroidLobApp sourceAndroidLobApp) {
        return sendAsync(HttpMethod.PATCH, sourceAndroidLobApp);
    }

    /**
     * Patches this AndroidLobApp with a source
     *
     * @param sourceAndroidLobApp the source object with updates
     * @return the updated AndroidLobApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AndroidLobApp patch(@Nonnull final AndroidLobApp sourceAndroidLobApp) throws ClientException {
        return send(HttpMethod.PATCH, sourceAndroidLobApp);
    }

    /**
     * Creates a AndroidLobApp with a new object
     *
     * @param newAndroidLobApp the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AndroidLobApp> postAsync(@Nonnull final AndroidLobApp newAndroidLobApp) {
        return sendAsync(HttpMethod.POST, newAndroidLobApp);
    }

    /**
     * Creates a AndroidLobApp with a new object
     *
     * @param newAndroidLobApp the new object to create
     * @return the created AndroidLobApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AndroidLobApp post(@Nonnull final AndroidLobApp newAndroidLobApp) throws ClientException {
        return send(HttpMethod.POST, newAndroidLobApp);
    }

    /**
     * Creates a AndroidLobApp with a new object
     *
     * @param newAndroidLobApp the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AndroidLobApp> putAsync(@Nonnull final AndroidLobApp newAndroidLobApp) {
        return sendAsync(HttpMethod.PUT, newAndroidLobApp);
    }

    /**
     * Creates a AndroidLobApp with a new object
     *
     * @param newAndroidLobApp the object to create/update
     * @return the created AndroidLobApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AndroidLobApp put(@Nonnull final AndroidLobApp newAndroidLobApp) throws ClientException {
        return send(HttpMethod.PUT, newAndroidLobApp);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AndroidLobAppRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AndroidLobAppRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

