// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.BaseItemVersion;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Item Version Request.
 */
public class BaseItemVersionRequest extends BaseRequest<BaseItemVersion> {
	
    /**
     * The request for the BaseItemVersion
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public BaseItemVersionRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends BaseItemVersion> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the BaseItemVersion
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public BaseItemVersionRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseItemVersion.class);
    }

    /**
     * Gets the BaseItemVersion from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BaseItemVersion> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the BaseItemVersion from the service
     *
     * @return the BaseItemVersion from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BaseItemVersion get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BaseItemVersion> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public BaseItemVersion delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this BaseItemVersion with a source
     *
     * @param sourceBaseItemVersion the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BaseItemVersion> patchAsync(@Nonnull final BaseItemVersion sourceBaseItemVersion) {
        return sendAsync(HttpMethod.PATCH, sourceBaseItemVersion);
    }

    /**
     * Patches this BaseItemVersion with a source
     *
     * @param sourceBaseItemVersion the source object with updates
     * @return the updated BaseItemVersion
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BaseItemVersion patch(@Nonnull final BaseItemVersion sourceBaseItemVersion) throws ClientException {
        return send(HttpMethod.PATCH, sourceBaseItemVersion);
    }

    /**
     * Creates a BaseItemVersion with a new object
     *
     * @param newBaseItemVersion the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BaseItemVersion> postAsync(@Nonnull final BaseItemVersion newBaseItemVersion) {
        return sendAsync(HttpMethod.POST, newBaseItemVersion);
    }

    /**
     * Creates a BaseItemVersion with a new object
     *
     * @param newBaseItemVersion the new object to create
     * @return the created BaseItemVersion
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BaseItemVersion post(@Nonnull final BaseItemVersion newBaseItemVersion) throws ClientException {
        return send(HttpMethod.POST, newBaseItemVersion);
    }

    /**
     * Creates a BaseItemVersion with a new object
     *
     * @param newBaseItemVersion the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BaseItemVersion> putAsync(@Nonnull final BaseItemVersion newBaseItemVersion) {
        return sendAsync(HttpMethod.PUT, newBaseItemVersion);
    }

    /**
     * Creates a BaseItemVersion with a new object
     *
     * @param newBaseItemVersion the object to create/update
     * @return the created BaseItemVersion
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BaseItemVersion put(@Nonnull final BaseItemVersion newBaseItemVersion) throws ClientException {
        return send(HttpMethod.PUT, newBaseItemVersion);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public BaseItemVersionRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public BaseItemVersionRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

