// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.CrossTenantAccessPolicyConfigurationDefaultResetToSystemDefaultRequest;
import com.microsoft.graph.models.CrossTenantAccessPolicyConfigurationDefault;

import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Cross Tenant Access Policy Configuration Default Reset To System Default Request Builder.
 */
public class CrossTenantAccessPolicyConfigurationDefaultResetToSystemDefaultRequestBuilder extends BaseActionRequestBuilder<CrossTenantAccessPolicyConfigurationDefault> {

    /**
     * The request builder for this CrossTenantAccessPolicyConfigurationDefaultResetToSystemDefault
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public CrossTenantAccessPolicyConfigurationDefaultResetToSystemDefaultRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the CrossTenantAccessPolicyConfigurationDefaultResetToSystemDefaultRequest
     *
     * @param requestOptions the options for the request
     * @return the CrossTenantAccessPolicyConfigurationDefaultResetToSystemDefaultRequest instance
     */
    @Nonnull
    public CrossTenantAccessPolicyConfigurationDefaultResetToSystemDefaultRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the CrossTenantAccessPolicyConfigurationDefaultResetToSystemDefaultRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the CrossTenantAccessPolicyConfigurationDefaultResetToSystemDefaultRequest instance
     */
    @Nonnull
    public CrossTenantAccessPolicyConfigurationDefaultResetToSystemDefaultRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final CrossTenantAccessPolicyConfigurationDefaultResetToSystemDefaultRequest request = new CrossTenantAccessPolicyConfigurationDefaultResetToSystemDefaultRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        return request;
    }
}
