// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.DeviceConfigurationUserStatus;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Configuration User Status Request.
 */
public class DeviceConfigurationUserStatusRequest extends BaseRequest<DeviceConfigurationUserStatus> {
	
    /**
     * The request for the DeviceConfigurationUserStatus
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DeviceConfigurationUserStatusRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceConfigurationUserStatus.class);
    }

    /**
     * Gets the DeviceConfigurationUserStatus from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceConfigurationUserStatus> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the DeviceConfigurationUserStatus from the service
     *
     * @return the DeviceConfigurationUserStatus from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceConfigurationUserStatus get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceConfigurationUserStatus> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public DeviceConfigurationUserStatus delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this DeviceConfigurationUserStatus with a source
     *
     * @param sourceDeviceConfigurationUserStatus the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceConfigurationUserStatus> patchAsync(@Nonnull final DeviceConfigurationUserStatus sourceDeviceConfigurationUserStatus) {
        return sendAsync(HttpMethod.PATCH, sourceDeviceConfigurationUserStatus);
    }

    /**
     * Patches this DeviceConfigurationUserStatus with a source
     *
     * @param sourceDeviceConfigurationUserStatus the source object with updates
     * @return the updated DeviceConfigurationUserStatus
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceConfigurationUserStatus patch(@Nonnull final DeviceConfigurationUserStatus sourceDeviceConfigurationUserStatus) throws ClientException {
        return send(HttpMethod.PATCH, sourceDeviceConfigurationUserStatus);
    }

    /**
     * Creates a DeviceConfigurationUserStatus with a new object
     *
     * @param newDeviceConfigurationUserStatus the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceConfigurationUserStatus> postAsync(@Nonnull final DeviceConfigurationUserStatus newDeviceConfigurationUserStatus) {
        return sendAsync(HttpMethod.POST, newDeviceConfigurationUserStatus);
    }

    /**
     * Creates a DeviceConfigurationUserStatus with a new object
     *
     * @param newDeviceConfigurationUserStatus the new object to create
     * @return the created DeviceConfigurationUserStatus
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceConfigurationUserStatus post(@Nonnull final DeviceConfigurationUserStatus newDeviceConfigurationUserStatus) throws ClientException {
        return send(HttpMethod.POST, newDeviceConfigurationUserStatus);
    }

    /**
     * Creates a DeviceConfigurationUserStatus with a new object
     *
     * @param newDeviceConfigurationUserStatus the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceConfigurationUserStatus> putAsync(@Nonnull final DeviceConfigurationUserStatus newDeviceConfigurationUserStatus) {
        return sendAsync(HttpMethod.PUT, newDeviceConfigurationUserStatus);
    }

    /**
     * Creates a DeviceConfigurationUserStatus with a new object
     *
     * @param newDeviceConfigurationUserStatus the object to create/update
     * @return the created DeviceConfigurationUserStatus
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceConfigurationUserStatus put(@Nonnull final DeviceConfigurationUserStatus newDeviceConfigurationUserStatus) throws ClientException {
        return send(HttpMethod.PUT, newDeviceConfigurationUserStatus);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public DeviceConfigurationUserStatusRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public DeviceConfigurationUserStatusRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

