// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.EducationAssignmentSettings;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Education Assignment Settings Request.
 */
public class EducationAssignmentSettingsRequest extends BaseRequest<EducationAssignmentSettings> {
	
    /**
     * The request for the EducationAssignmentSettings
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EducationAssignmentSettingsRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EducationAssignmentSettings.class);
    }

    /**
     * Gets the EducationAssignmentSettings from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationAssignmentSettings> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the EducationAssignmentSettings from the service
     *
     * @return the EducationAssignmentSettings from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationAssignmentSettings get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationAssignmentSettings> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public EducationAssignmentSettings delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this EducationAssignmentSettings with a source
     *
     * @param sourceEducationAssignmentSettings the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationAssignmentSettings> patchAsync(@Nonnull final EducationAssignmentSettings sourceEducationAssignmentSettings) {
        return sendAsync(HttpMethod.PATCH, sourceEducationAssignmentSettings);
    }

    /**
     * Patches this EducationAssignmentSettings with a source
     *
     * @param sourceEducationAssignmentSettings the source object with updates
     * @return the updated EducationAssignmentSettings
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationAssignmentSettings patch(@Nonnull final EducationAssignmentSettings sourceEducationAssignmentSettings) throws ClientException {
        return send(HttpMethod.PATCH, sourceEducationAssignmentSettings);
    }

    /**
     * Creates a EducationAssignmentSettings with a new object
     *
     * @param newEducationAssignmentSettings the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationAssignmentSettings> postAsync(@Nonnull final EducationAssignmentSettings newEducationAssignmentSettings) {
        return sendAsync(HttpMethod.POST, newEducationAssignmentSettings);
    }

    /**
     * Creates a EducationAssignmentSettings with a new object
     *
     * @param newEducationAssignmentSettings the new object to create
     * @return the created EducationAssignmentSettings
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationAssignmentSettings post(@Nonnull final EducationAssignmentSettings newEducationAssignmentSettings) throws ClientException {
        return send(HttpMethod.POST, newEducationAssignmentSettings);
    }

    /**
     * Creates a EducationAssignmentSettings with a new object
     *
     * @param newEducationAssignmentSettings the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationAssignmentSettings> putAsync(@Nonnull final EducationAssignmentSettings newEducationAssignmentSettings) {
        return sendAsync(HttpMethod.PUT, newEducationAssignmentSettings);
    }

    /**
     * Creates a EducationAssignmentSettings with a new object
     *
     * @param newEducationAssignmentSettings the object to create/update
     * @return the created EducationAssignmentSettings
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationAssignmentSettings put(@Nonnull final EducationAssignmentSettings newEducationAssignmentSettings) throws ClientException {
        return send(HttpMethod.PUT, newEducationAssignmentSettings);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public EducationAssignmentSettingsRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public EducationAssignmentSettingsRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

