// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.EnrollmentConfigurationAssignment;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Enrollment Configuration Assignment Request.
 */
public class EnrollmentConfigurationAssignmentRequest extends BaseRequest<EnrollmentConfigurationAssignment> {
	
    /**
     * The request for the EnrollmentConfigurationAssignment
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EnrollmentConfigurationAssignmentRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EnrollmentConfigurationAssignment.class);
    }

    /**
     * Gets the EnrollmentConfigurationAssignment from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EnrollmentConfigurationAssignment> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the EnrollmentConfigurationAssignment from the service
     *
     * @return the EnrollmentConfigurationAssignment from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EnrollmentConfigurationAssignment get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EnrollmentConfigurationAssignment> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public EnrollmentConfigurationAssignment delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this EnrollmentConfigurationAssignment with a source
     *
     * @param sourceEnrollmentConfigurationAssignment the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EnrollmentConfigurationAssignment> patchAsync(@Nonnull final EnrollmentConfigurationAssignment sourceEnrollmentConfigurationAssignment) {
        return sendAsync(HttpMethod.PATCH, sourceEnrollmentConfigurationAssignment);
    }

    /**
     * Patches this EnrollmentConfigurationAssignment with a source
     *
     * @param sourceEnrollmentConfigurationAssignment the source object with updates
     * @return the updated EnrollmentConfigurationAssignment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EnrollmentConfigurationAssignment patch(@Nonnull final EnrollmentConfigurationAssignment sourceEnrollmentConfigurationAssignment) throws ClientException {
        return send(HttpMethod.PATCH, sourceEnrollmentConfigurationAssignment);
    }

    /**
     * Creates a EnrollmentConfigurationAssignment with a new object
     *
     * @param newEnrollmentConfigurationAssignment the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EnrollmentConfigurationAssignment> postAsync(@Nonnull final EnrollmentConfigurationAssignment newEnrollmentConfigurationAssignment) {
        return sendAsync(HttpMethod.POST, newEnrollmentConfigurationAssignment);
    }

    /**
     * Creates a EnrollmentConfigurationAssignment with a new object
     *
     * @param newEnrollmentConfigurationAssignment the new object to create
     * @return the created EnrollmentConfigurationAssignment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EnrollmentConfigurationAssignment post(@Nonnull final EnrollmentConfigurationAssignment newEnrollmentConfigurationAssignment) throws ClientException {
        return send(HttpMethod.POST, newEnrollmentConfigurationAssignment);
    }

    /**
     * Creates a EnrollmentConfigurationAssignment with a new object
     *
     * @param newEnrollmentConfigurationAssignment the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EnrollmentConfigurationAssignment> putAsync(@Nonnull final EnrollmentConfigurationAssignment newEnrollmentConfigurationAssignment) {
        return sendAsync(HttpMethod.PUT, newEnrollmentConfigurationAssignment);
    }

    /**
     * Creates a EnrollmentConfigurationAssignment with a new object
     *
     * @param newEnrollmentConfigurationAssignment the object to create/update
     * @return the created EnrollmentConfigurationAssignment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EnrollmentConfigurationAssignment put(@Nonnull final EnrollmentConfigurationAssignment newEnrollmentConfigurationAssignment) throws ClientException {
        return send(HttpMethod.PUT, newEnrollmentConfigurationAssignment);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public EnrollmentConfigurationAssignmentRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public EnrollmentConfigurationAssignmentRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

