// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ExternalDomainName;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the External Domain Name Request.
 */
public class ExternalDomainNameRequest extends BaseRequest<ExternalDomainName> {
	
    /**
     * The request for the ExternalDomainName
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ExternalDomainNameRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ExternalDomainName.class);
    }

    /**
     * Gets the ExternalDomainName from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ExternalDomainName> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ExternalDomainName from the service
     *
     * @return the ExternalDomainName from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ExternalDomainName get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ExternalDomainName> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ExternalDomainName delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ExternalDomainName with a source
     *
     * @param sourceExternalDomainName the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ExternalDomainName> patchAsync(@Nonnull final ExternalDomainName sourceExternalDomainName) {
        return sendAsync(HttpMethod.PATCH, sourceExternalDomainName);
    }

    /**
     * Patches this ExternalDomainName with a source
     *
     * @param sourceExternalDomainName the source object with updates
     * @return the updated ExternalDomainName
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ExternalDomainName patch(@Nonnull final ExternalDomainName sourceExternalDomainName) throws ClientException {
        return send(HttpMethod.PATCH, sourceExternalDomainName);
    }

    /**
     * Creates a ExternalDomainName with a new object
     *
     * @param newExternalDomainName the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ExternalDomainName> postAsync(@Nonnull final ExternalDomainName newExternalDomainName) {
        return sendAsync(HttpMethod.POST, newExternalDomainName);
    }

    /**
     * Creates a ExternalDomainName with a new object
     *
     * @param newExternalDomainName the new object to create
     * @return the created ExternalDomainName
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ExternalDomainName post(@Nonnull final ExternalDomainName newExternalDomainName) throws ClientException {
        return send(HttpMethod.POST, newExternalDomainName);
    }

    /**
     * Creates a ExternalDomainName with a new object
     *
     * @param newExternalDomainName the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ExternalDomainName> putAsync(@Nonnull final ExternalDomainName newExternalDomainName) {
        return sendAsync(HttpMethod.PUT, newExternalDomainName);
    }

    /**
     * Creates a ExternalDomainName with a new object
     *
     * @param newExternalDomainName the object to create/update
     * @return the created ExternalDomainName
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ExternalDomainName put(@Nonnull final ExternalDomainName newExternalDomainName) throws ClientException {
        return send(HttpMethod.PUT, newExternalDomainName);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ExternalDomainNameRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ExternalDomainNameRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

