// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.IosStoreApp;
import com.microsoft.graph.models.MobileAppAssignment;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ios Store App Request.
 */
public class IosStoreAppRequest extends BaseRequest<IosStoreApp> {
	
    /**
     * The request for the IosStoreApp
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public IosStoreAppRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, IosStoreApp.class);
    }

    /**
     * Gets the IosStoreApp from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IosStoreApp> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the IosStoreApp from the service
     *
     * @return the IosStoreApp from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IosStoreApp get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IosStoreApp> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public IosStoreApp delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this IosStoreApp with a source
     *
     * @param sourceIosStoreApp the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IosStoreApp> patchAsync(@Nonnull final IosStoreApp sourceIosStoreApp) {
        return sendAsync(HttpMethod.PATCH, sourceIosStoreApp);
    }

    /**
     * Patches this IosStoreApp with a source
     *
     * @param sourceIosStoreApp the source object with updates
     * @return the updated IosStoreApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IosStoreApp patch(@Nonnull final IosStoreApp sourceIosStoreApp) throws ClientException {
        return send(HttpMethod.PATCH, sourceIosStoreApp);
    }

    /**
     * Creates a IosStoreApp with a new object
     *
     * @param newIosStoreApp the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IosStoreApp> postAsync(@Nonnull final IosStoreApp newIosStoreApp) {
        return sendAsync(HttpMethod.POST, newIosStoreApp);
    }

    /**
     * Creates a IosStoreApp with a new object
     *
     * @param newIosStoreApp the new object to create
     * @return the created IosStoreApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IosStoreApp post(@Nonnull final IosStoreApp newIosStoreApp) throws ClientException {
        return send(HttpMethod.POST, newIosStoreApp);
    }

    /**
     * Creates a IosStoreApp with a new object
     *
     * @param newIosStoreApp the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IosStoreApp> putAsync(@Nonnull final IosStoreApp newIosStoreApp) {
        return sendAsync(HttpMethod.PUT, newIosStoreApp);
    }

    /**
     * Creates a IosStoreApp with a new object
     *
     * @param newIosStoreApp the object to create/update
     * @return the created IosStoreApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IosStoreApp put(@Nonnull final IosStoreApp newIosStoreApp) throws ClientException {
        return send(HttpMethod.PUT, newIosStoreApp);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public IosStoreAppRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public IosStoreAppRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

