// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.MicrosoftAuthenticatorAuthenticationMethod;
import com.microsoft.graph.models.PasswordResetResponse;
import com.microsoft.graph.requests.DeviceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Microsoft Authenticator Authentication Method Request.
 */
public class MicrosoftAuthenticatorAuthenticationMethodRequest extends BaseRequest<MicrosoftAuthenticatorAuthenticationMethod> {
	
    /**
     * The request for the MicrosoftAuthenticatorAuthenticationMethod
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public MicrosoftAuthenticatorAuthenticationMethodRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, MicrosoftAuthenticatorAuthenticationMethod.class);
    }

    /**
     * Gets the MicrosoftAuthenticatorAuthenticationMethod from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MicrosoftAuthenticatorAuthenticationMethod> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the MicrosoftAuthenticatorAuthenticationMethod from the service
     *
     * @return the MicrosoftAuthenticatorAuthenticationMethod from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MicrosoftAuthenticatorAuthenticationMethod get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MicrosoftAuthenticatorAuthenticationMethod> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public MicrosoftAuthenticatorAuthenticationMethod delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this MicrosoftAuthenticatorAuthenticationMethod with a source
     *
     * @param sourceMicrosoftAuthenticatorAuthenticationMethod the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MicrosoftAuthenticatorAuthenticationMethod> patchAsync(@Nonnull final MicrosoftAuthenticatorAuthenticationMethod sourceMicrosoftAuthenticatorAuthenticationMethod) {
        return sendAsync(HttpMethod.PATCH, sourceMicrosoftAuthenticatorAuthenticationMethod);
    }

    /**
     * Patches this MicrosoftAuthenticatorAuthenticationMethod with a source
     *
     * @param sourceMicrosoftAuthenticatorAuthenticationMethod the source object with updates
     * @return the updated MicrosoftAuthenticatorAuthenticationMethod
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MicrosoftAuthenticatorAuthenticationMethod patch(@Nonnull final MicrosoftAuthenticatorAuthenticationMethod sourceMicrosoftAuthenticatorAuthenticationMethod) throws ClientException {
        return send(HttpMethod.PATCH, sourceMicrosoftAuthenticatorAuthenticationMethod);
    }

    /**
     * Creates a MicrosoftAuthenticatorAuthenticationMethod with a new object
     *
     * @param newMicrosoftAuthenticatorAuthenticationMethod the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MicrosoftAuthenticatorAuthenticationMethod> postAsync(@Nonnull final MicrosoftAuthenticatorAuthenticationMethod newMicrosoftAuthenticatorAuthenticationMethod) {
        return sendAsync(HttpMethod.POST, newMicrosoftAuthenticatorAuthenticationMethod);
    }

    /**
     * Creates a MicrosoftAuthenticatorAuthenticationMethod with a new object
     *
     * @param newMicrosoftAuthenticatorAuthenticationMethod the new object to create
     * @return the created MicrosoftAuthenticatorAuthenticationMethod
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MicrosoftAuthenticatorAuthenticationMethod post(@Nonnull final MicrosoftAuthenticatorAuthenticationMethod newMicrosoftAuthenticatorAuthenticationMethod) throws ClientException {
        return send(HttpMethod.POST, newMicrosoftAuthenticatorAuthenticationMethod);
    }

    /**
     * Creates a MicrosoftAuthenticatorAuthenticationMethod with a new object
     *
     * @param newMicrosoftAuthenticatorAuthenticationMethod the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MicrosoftAuthenticatorAuthenticationMethod> putAsync(@Nonnull final MicrosoftAuthenticatorAuthenticationMethod newMicrosoftAuthenticatorAuthenticationMethod) {
        return sendAsync(HttpMethod.PUT, newMicrosoftAuthenticatorAuthenticationMethod);
    }

    /**
     * Creates a MicrosoftAuthenticatorAuthenticationMethod with a new object
     *
     * @param newMicrosoftAuthenticatorAuthenticationMethod the object to create/update
     * @return the created MicrosoftAuthenticatorAuthenticationMethod
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MicrosoftAuthenticatorAuthenticationMethod put(@Nonnull final MicrosoftAuthenticatorAuthenticationMethod newMicrosoftAuthenticatorAuthenticationMethod) throws ClientException {
        return send(HttpMethod.PUT, newMicrosoftAuthenticatorAuthenticationMethod);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public MicrosoftAuthenticatorAuthenticationMethodRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public MicrosoftAuthenticatorAuthenticationMethodRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

