// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.OnlineMeeting;
import com.microsoft.graph.models.ChatInfo;
import com.microsoft.graph.models.MeetingParticipants;
import com.microsoft.graph.requests.MeetingAttendanceReportCollectionRequestBuilder;
import com.microsoft.graph.requests.MeetingAttendanceReportRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Online Meeting Request Builder.
 */
public class OnlineMeetingRequestBuilder extends BaseRequestBuilder<OnlineMeeting> {

    /**
     * The request builder for the OnlineMeeting
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OnlineMeetingRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the OnlineMeetingRequest instance
     */
    @Nonnull
    public OnlineMeetingRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the OnlineMeetingRequest instance
     */
    @Nonnull
    public OnlineMeetingRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.OnlineMeetingRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the MeetingAttendanceReport collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public MeetingAttendanceReportCollectionRequestBuilder attendanceReports() {
        return new MeetingAttendanceReportCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("attendanceReports"), getClient(), null);
    }

    /**
     * Gets a request builder for the MeetingAttendanceReport item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public MeetingAttendanceReportRequestBuilder attendanceReports(@Nonnull final String id) {
        return new MeetingAttendanceReportRequestBuilder(getRequestUrlWithAdditionalSegment("attendanceReports") + "/" + id, getClient(), null);
    }

    /**
     * Gets the request builder for attendeeReport
     *
     * @return the OnlineMeetingAttendeeReportStreamRequestBuilder instance
     */
    @Nonnull
    public OnlineMeetingAttendeeReportStreamRequestBuilder attendeeReport() {
        return new OnlineMeetingAttendeeReportStreamRequestBuilder(getRequestUrlWithAdditionalSegment("attendeeReport"), getClient(), null);
    }
}
