// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.PrintDocument;
import com.microsoft.graph.models.PrintDocumentUploadProperties;
import com.microsoft.graph.models.UploadSession;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.models.PrintDocumentCreateUploadSessionParameterSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Print Document Request Builder.
 */
public class PrintDocumentRequestBuilder extends BaseRequestBuilder<PrintDocument> {

    /**
     * The request builder for the PrintDocument
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrintDocumentRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the PrintDocumentRequest instance
     */
    @Nonnull
    public PrintDocumentRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the PrintDocumentRequest instance
     */
    @Nonnull
    public PrintDocumentRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.PrintDocumentRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets a request builder to get the binary value of the object
     * @return the stream request builder
     */
    @Nonnull
    public PrintDocumentStreamRequestBuilder content() {
        return new PrintDocumentStreamRequestBuilder(getRequestUrlWithAdditionalSegment("$value"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public PrintDocumentCreateUploadSessionRequestBuilder createUploadSession(@Nonnull final PrintDocumentCreateUploadSessionParameterSet parameters) {
        return new PrintDocumentCreateUploadSessionRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.createUploadSession"), getClient(), null, parameters);
    }
}
