// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.SingleValueLegacyExtendedProperty;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Single Value Legacy Extended Property Request.
 */
public class SingleValueLegacyExtendedPropertyRequest extends BaseRequest<SingleValueLegacyExtendedProperty> {
	
    /**
     * The request for the SingleValueLegacyExtendedProperty
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SingleValueLegacyExtendedPropertyRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, SingleValueLegacyExtendedProperty.class);
    }

    /**
     * Gets the SingleValueLegacyExtendedProperty from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SingleValueLegacyExtendedProperty> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the SingleValueLegacyExtendedProperty from the service
     *
     * @return the SingleValueLegacyExtendedProperty from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SingleValueLegacyExtendedProperty get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SingleValueLegacyExtendedProperty> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public SingleValueLegacyExtendedProperty delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this SingleValueLegacyExtendedProperty with a source
     *
     * @param sourceSingleValueLegacyExtendedProperty the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SingleValueLegacyExtendedProperty> patchAsync(@Nonnull final SingleValueLegacyExtendedProperty sourceSingleValueLegacyExtendedProperty) {
        return sendAsync(HttpMethod.PATCH, sourceSingleValueLegacyExtendedProperty);
    }

    /**
     * Patches this SingleValueLegacyExtendedProperty with a source
     *
     * @param sourceSingleValueLegacyExtendedProperty the source object with updates
     * @return the updated SingleValueLegacyExtendedProperty
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SingleValueLegacyExtendedProperty patch(@Nonnull final SingleValueLegacyExtendedProperty sourceSingleValueLegacyExtendedProperty) throws ClientException {
        return send(HttpMethod.PATCH, sourceSingleValueLegacyExtendedProperty);
    }

    /**
     * Creates a SingleValueLegacyExtendedProperty with a new object
     *
     * @param newSingleValueLegacyExtendedProperty the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SingleValueLegacyExtendedProperty> postAsync(@Nonnull final SingleValueLegacyExtendedProperty newSingleValueLegacyExtendedProperty) {
        return sendAsync(HttpMethod.POST, newSingleValueLegacyExtendedProperty);
    }

    /**
     * Creates a SingleValueLegacyExtendedProperty with a new object
     *
     * @param newSingleValueLegacyExtendedProperty the new object to create
     * @return the created SingleValueLegacyExtendedProperty
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SingleValueLegacyExtendedProperty post(@Nonnull final SingleValueLegacyExtendedProperty newSingleValueLegacyExtendedProperty) throws ClientException {
        return send(HttpMethod.POST, newSingleValueLegacyExtendedProperty);
    }

    /**
     * Creates a SingleValueLegacyExtendedProperty with a new object
     *
     * @param newSingleValueLegacyExtendedProperty the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SingleValueLegacyExtendedProperty> putAsync(@Nonnull final SingleValueLegacyExtendedProperty newSingleValueLegacyExtendedProperty) {
        return sendAsync(HttpMethod.PUT, newSingleValueLegacyExtendedProperty);
    }

    /**
     * Creates a SingleValueLegacyExtendedProperty with a new object
     *
     * @param newSingleValueLegacyExtendedProperty the object to create/update
     * @return the created SingleValueLegacyExtendedProperty
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SingleValueLegacyExtendedProperty put(@Nonnull final SingleValueLegacyExtendedProperty newSingleValueLegacyExtendedProperty) throws ClientException {
        return send(HttpMethod.PUT, newSingleValueLegacyExtendedProperty);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public SingleValueLegacyExtendedPropertyRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public SingleValueLegacyExtendedPropertyRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

