// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.SocialIdentityProvider;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Social Identity Provider Request.
 */
public class SocialIdentityProviderRequest extends BaseRequest<SocialIdentityProvider> {
	
    /**
     * The request for the SocialIdentityProvider
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SocialIdentityProviderRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, SocialIdentityProvider.class);
    }

    /**
     * Gets the SocialIdentityProvider from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SocialIdentityProvider> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the SocialIdentityProvider from the service
     *
     * @return the SocialIdentityProvider from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SocialIdentityProvider get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SocialIdentityProvider> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public SocialIdentityProvider delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this SocialIdentityProvider with a source
     *
     * @param sourceSocialIdentityProvider the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SocialIdentityProvider> patchAsync(@Nonnull final SocialIdentityProvider sourceSocialIdentityProvider) {
        return sendAsync(HttpMethod.PATCH, sourceSocialIdentityProvider);
    }

    /**
     * Patches this SocialIdentityProvider with a source
     *
     * @param sourceSocialIdentityProvider the source object with updates
     * @return the updated SocialIdentityProvider
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SocialIdentityProvider patch(@Nonnull final SocialIdentityProvider sourceSocialIdentityProvider) throws ClientException {
        return send(HttpMethod.PATCH, sourceSocialIdentityProvider);
    }

    /**
     * Creates a SocialIdentityProvider with a new object
     *
     * @param newSocialIdentityProvider the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SocialIdentityProvider> postAsync(@Nonnull final SocialIdentityProvider newSocialIdentityProvider) {
        return sendAsync(HttpMethod.POST, newSocialIdentityProvider);
    }

    /**
     * Creates a SocialIdentityProvider with a new object
     *
     * @param newSocialIdentityProvider the new object to create
     * @return the created SocialIdentityProvider
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SocialIdentityProvider post(@Nonnull final SocialIdentityProvider newSocialIdentityProvider) throws ClientException {
        return send(HttpMethod.POST, newSocialIdentityProvider);
    }

    /**
     * Creates a SocialIdentityProvider with a new object
     *
     * @param newSocialIdentityProvider the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SocialIdentityProvider> putAsync(@Nonnull final SocialIdentityProvider newSocialIdentityProvider) {
        return sendAsync(HttpMethod.PUT, newSocialIdentityProvider);
    }

    /**
     * Creates a SocialIdentityProvider with a new object
     *
     * @param newSocialIdentityProvider the object to create/update
     * @return the created SocialIdentityProvider
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SocialIdentityProvider put(@Nonnull final SocialIdentityProvider newSocialIdentityProvider) throws ClientException {
        return send(HttpMethod.PUT, newSocialIdentityProvider);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public SocialIdentityProviderRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public SocialIdentityProviderRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

