// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.SubjectRightsRequest;
import com.microsoft.graph.requests.AuthoredNoteCollectionRequestBuilder;
import com.microsoft.graph.requests.AuthoredNoteRequestBuilder;
import com.microsoft.graph.requests.TeamWithReferenceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Subject Rights Request Request Builder.
 */
public class SubjectRightsRequestRequestBuilder extends BaseRequestBuilder<SubjectRightsRequest> {

    /**
     * The request builder for the SubjectRightsRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SubjectRightsRequestRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the SubjectRightsRequestRequest instance
     */
    @Nonnull
    public SubjectRightsRequestRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the SubjectRightsRequestRequest instance
     */
    @Nonnull
    public SubjectRightsRequestRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.SubjectRightsRequestRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the AuthoredNote collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public AuthoredNoteCollectionRequestBuilder notes() {
        return new AuthoredNoteCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("notes"), getClient(), null);
    }

    /**
     * Gets a request builder for the AuthoredNote item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public AuthoredNoteRequestBuilder notes(@Nonnull final String id) {
        return new AuthoredNoteRequestBuilder(getRequestUrlWithAdditionalSegment("notes") + "/" + id, getClient(), null);
    }

    /**
     * Gets the request builder for Team
     *
     * @return the TeamWithReferenceRequestBuilder instance
     */
    @Nonnull
    public TeamWithReferenceRequestBuilder team() {
        return new TeamWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("team"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public SubjectRightsRequestGetFinalAttachmentRequestBuilder getFinalAttachment() {
        return new SubjectRightsRequestGetFinalAttachmentRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getFinalAttachment"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public SubjectRightsRequestGetFinalReportRequestBuilder getFinalReport() {
        return new SubjectRightsRequestGetFinalReportRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getFinalReport"), getClient(), null);
    }
}
