// Template Source: BaseMethodCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.RoleAssignmentScheduleRequestFilterByCurrentUserOptions;
import com.microsoft.graph.models.UnifiedRoleAssignmentScheduleRequest;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.UnifiedRoleAssignmentScheduleRequestFilterByCurrentUserCollectionRequestBuilder;
import com.microsoft.graph.requests.UnifiedRoleAssignmentScheduleRequestFilterByCurrentUserCollectionRequest;
import com.microsoft.graph.requests.UnifiedRoleAssignmentScheduleRequestFilterByCurrentUserCollectionResponse;
import com.microsoft.graph.models.UnifiedRoleAssignmentScheduleRequestFilterByCurrentUserParameterSet;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseFunctionCollectionRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Unified Role Assignment Schedule Request Filter By Current User Collection Request Builder.
 */
public class UnifiedRoleAssignmentScheduleRequestFilterByCurrentUserCollectionRequestBuilder extends BaseFunctionCollectionRequestBuilder<UnifiedRoleAssignmentScheduleRequest, UnifiedRoleAssignmentScheduleRequestFilterByCurrentUserCollectionRequestBuilder, UnifiedRoleAssignmentScheduleRequestFilterByCurrentUserCollectionResponse, UnifiedRoleAssignmentScheduleRequestFilterByCurrentUserCollectionPage, UnifiedRoleAssignmentScheduleRequestFilterByCurrentUserCollectionRequest> {

    /**
     * The request builder for this collection of UnifiedRoleAssignmentScheduleRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UnifiedRoleAssignmentScheduleRequestFilterByCurrentUserCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UnifiedRoleAssignmentScheduleRequestFilterByCurrentUserCollectionRequestBuilder.class, UnifiedRoleAssignmentScheduleRequestFilterByCurrentUserCollectionRequest.class);
    }
    /**
     * The request builder for this collection of UnifiedRoleAssignmentScheduleRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public UnifiedRoleAssignmentScheduleRequestFilterByCurrentUserCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final UnifiedRoleAssignmentScheduleRequestFilterByCurrentUserParameterSet parameters) {
        super(requestUrl, client, requestOptions, UnifiedRoleAssignmentScheduleRequestFilterByCurrentUserCollectionRequestBuilder.class, UnifiedRoleAssignmentScheduleRequestFilterByCurrentUserCollectionRequest.class);
        if(parameters != null) {
            functionOptions = parameters.getFunctionOptions();
        }
    }
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the UnifiedRoleAssignmentScheduleRequestFilterByCurrentUserCollectionRequest instance
     */
    @Override
    @Nonnull
    public UnifiedRoleAssignmentScheduleRequestFilterByCurrentUserCollectionRequest buildRequest(@Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final UnifiedRoleAssignmentScheduleRequestFilterByCurrentUserCollectionRequest request = super.buildRequest(requestOptions);
        if(functionOptions != null) {    
            for (com.microsoft.graph.options.FunctionOption option : functionOptions) {
                request.addFunctionOption(option);
            }
        }
        return request;
    }
}
