// Template Source: BaseMethodCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.RoleEligibilityScheduleInstanceFilterByCurrentUserOptions;
import com.microsoft.graph.models.UnifiedRoleEligibilityScheduleInstance;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.UnifiedRoleEligibilityScheduleInstanceFilterByCurrentUserCollectionRequestBuilder;
import com.microsoft.graph.requests.UnifiedRoleEligibilityScheduleInstanceFilterByCurrentUserCollectionRequest;
import com.microsoft.graph.requests.UnifiedRoleEligibilityScheduleInstanceFilterByCurrentUserCollectionResponse;
import com.microsoft.graph.models.UnifiedRoleEligibilityScheduleInstanceFilterByCurrentUserParameterSet;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseFunctionCollectionRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Unified Role Eligibility Schedule Instance Filter By Current User Collection Request Builder.
 */
public class UnifiedRoleEligibilityScheduleInstanceFilterByCurrentUserCollectionRequestBuilder extends BaseFunctionCollectionRequestBuilder<UnifiedRoleEligibilityScheduleInstance, UnifiedRoleEligibilityScheduleInstanceFilterByCurrentUserCollectionRequestBuilder, UnifiedRoleEligibilityScheduleInstanceFilterByCurrentUserCollectionResponse, UnifiedRoleEligibilityScheduleInstanceFilterByCurrentUserCollectionPage, UnifiedRoleEligibilityScheduleInstanceFilterByCurrentUserCollectionRequest> {

    /**
     * The request builder for this collection of UnifiedRoleEligibilityScheduleInstance
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UnifiedRoleEligibilityScheduleInstanceFilterByCurrentUserCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UnifiedRoleEligibilityScheduleInstanceFilterByCurrentUserCollectionRequestBuilder.class, UnifiedRoleEligibilityScheduleInstanceFilterByCurrentUserCollectionRequest.class);
    }
    /**
     * The request builder for this collection of UnifiedRoleEligibilityScheduleInstance
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public UnifiedRoleEligibilityScheduleInstanceFilterByCurrentUserCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final UnifiedRoleEligibilityScheduleInstanceFilterByCurrentUserParameterSet parameters) {
        super(requestUrl, client, requestOptions, UnifiedRoleEligibilityScheduleInstanceFilterByCurrentUserCollectionRequestBuilder.class, UnifiedRoleEligibilityScheduleInstanceFilterByCurrentUserCollectionRequest.class);
        if(parameters != null) {
            functionOptions = parameters.getFunctionOptions();
        }
    }
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the UnifiedRoleEligibilityScheduleInstanceFilterByCurrentUserCollectionRequest instance
     */
    @Override
    @Nonnull
    public UnifiedRoleEligibilityScheduleInstanceFilterByCurrentUserCollectionRequest buildRequest(@Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final UnifiedRoleEligibilityScheduleInstanceFilterByCurrentUserCollectionRequest request = super.buildRequest(requestOptions);
        if(functionOptions != null) {    
            for (com.microsoft.graph.options.FunctionOption option : functionOptions) {
                request.addFunctionOption(option);
            }
        }
        return request;
    }
}
