// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Windows10CustomConfiguration;
import com.microsoft.graph.models.DeviceConfigurationAssignment;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows10Custom Configuration Request.
 */
public class Windows10CustomConfigurationRequest extends BaseRequest<Windows10CustomConfiguration> {
	
    /**
     * The request for the Windows10CustomConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public Windows10CustomConfigurationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Windows10CustomConfiguration.class);
    }

    /**
     * Gets the Windows10CustomConfiguration from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Windows10CustomConfiguration> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Windows10CustomConfiguration from the service
     *
     * @return the Windows10CustomConfiguration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Windows10CustomConfiguration get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Windows10CustomConfiguration> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Windows10CustomConfiguration delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Windows10CustomConfiguration with a source
     *
     * @param sourceWindows10CustomConfiguration the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Windows10CustomConfiguration> patchAsync(@Nonnull final Windows10CustomConfiguration sourceWindows10CustomConfiguration) {
        return sendAsync(HttpMethod.PATCH, sourceWindows10CustomConfiguration);
    }

    /**
     * Patches this Windows10CustomConfiguration with a source
     *
     * @param sourceWindows10CustomConfiguration the source object with updates
     * @return the updated Windows10CustomConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Windows10CustomConfiguration patch(@Nonnull final Windows10CustomConfiguration sourceWindows10CustomConfiguration) throws ClientException {
        return send(HttpMethod.PATCH, sourceWindows10CustomConfiguration);
    }

    /**
     * Creates a Windows10CustomConfiguration with a new object
     *
     * @param newWindows10CustomConfiguration the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Windows10CustomConfiguration> postAsync(@Nonnull final Windows10CustomConfiguration newWindows10CustomConfiguration) {
        return sendAsync(HttpMethod.POST, newWindows10CustomConfiguration);
    }

    /**
     * Creates a Windows10CustomConfiguration with a new object
     *
     * @param newWindows10CustomConfiguration the new object to create
     * @return the created Windows10CustomConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Windows10CustomConfiguration post(@Nonnull final Windows10CustomConfiguration newWindows10CustomConfiguration) throws ClientException {
        return send(HttpMethod.POST, newWindows10CustomConfiguration);
    }

    /**
     * Creates a Windows10CustomConfiguration with a new object
     *
     * @param newWindows10CustomConfiguration the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Windows10CustomConfiguration> putAsync(@Nonnull final Windows10CustomConfiguration newWindows10CustomConfiguration) {
        return sendAsync(HttpMethod.PUT, newWindows10CustomConfiguration);
    }

    /**
     * Creates a Windows10CustomConfiguration with a new object
     *
     * @param newWindows10CustomConfiguration the object to create/update
     * @return the created Windows10CustomConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Windows10CustomConfiguration put(@Nonnull final Windows10CustomConfiguration newWindows10CustomConfiguration) throws ClientException {
        return send(HttpMethod.PUT, newWindows10CustomConfiguration);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public Windows10CustomConfigurationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public Windows10CustomConfigurationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

