// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.WorkbookChartTitleFormat;
import com.microsoft.graph.requests.WorkbookChartFillRequestBuilder;
import com.microsoft.graph.requests.WorkbookChartFontRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Chart Title Format Request.
 */
public class WorkbookChartTitleFormatRequest extends BaseRequest<WorkbookChartTitleFormat> {
	
    /**
     * The request for the WorkbookChartTitleFormat
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookChartTitleFormatRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookChartTitleFormat.class);
    }

    /**
     * Gets the WorkbookChartTitleFormat from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookChartTitleFormat> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the WorkbookChartTitleFormat from the service
     *
     * @return the WorkbookChartTitleFormat from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookChartTitleFormat get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookChartTitleFormat> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public WorkbookChartTitleFormat delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WorkbookChartTitleFormat with a source
     *
     * @param sourceWorkbookChartTitleFormat the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookChartTitleFormat> patchAsync(@Nonnull final WorkbookChartTitleFormat sourceWorkbookChartTitleFormat) {
        return sendAsync(HttpMethod.PATCH, sourceWorkbookChartTitleFormat);
    }

    /**
     * Patches this WorkbookChartTitleFormat with a source
     *
     * @param sourceWorkbookChartTitleFormat the source object with updates
     * @return the updated WorkbookChartTitleFormat
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookChartTitleFormat patch(@Nonnull final WorkbookChartTitleFormat sourceWorkbookChartTitleFormat) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookChartTitleFormat);
    }

    /**
     * Creates a WorkbookChartTitleFormat with a new object
     *
     * @param newWorkbookChartTitleFormat the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookChartTitleFormat> postAsync(@Nonnull final WorkbookChartTitleFormat newWorkbookChartTitleFormat) {
        return sendAsync(HttpMethod.POST, newWorkbookChartTitleFormat);
    }

    /**
     * Creates a WorkbookChartTitleFormat with a new object
     *
     * @param newWorkbookChartTitleFormat the new object to create
     * @return the created WorkbookChartTitleFormat
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookChartTitleFormat post(@Nonnull final WorkbookChartTitleFormat newWorkbookChartTitleFormat) throws ClientException {
        return send(HttpMethod.POST, newWorkbookChartTitleFormat);
    }

    /**
     * Creates a WorkbookChartTitleFormat with a new object
     *
     * @param newWorkbookChartTitleFormat the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookChartTitleFormat> putAsync(@Nonnull final WorkbookChartTitleFormat newWorkbookChartTitleFormat) {
        return sendAsync(HttpMethod.PUT, newWorkbookChartTitleFormat);
    }

    /**
     * Creates a WorkbookChartTitleFormat with a new object
     *
     * @param newWorkbookChartTitleFormat the object to create/update
     * @return the created WorkbookChartTitleFormat
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookChartTitleFormat put(@Nonnull final WorkbookChartTitleFormat newWorkbookChartTitleFormat) throws ClientException {
        return send(HttpMethod.PUT, newWorkbookChartTitleFormat);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public WorkbookChartTitleFormatRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public WorkbookChartTitleFormatRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

