// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.WorkbookRangeBorder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Range Border Request.
 */
public class WorkbookRangeBorderRequest extends BaseRequest<WorkbookRangeBorder> {
	
    /**
     * The request for the WorkbookRangeBorder
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookRangeBorderRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookRangeBorder.class);
    }

    /**
     * Gets the WorkbookRangeBorder from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookRangeBorder> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the WorkbookRangeBorder from the service
     *
     * @return the WorkbookRangeBorder from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookRangeBorder get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookRangeBorder> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public WorkbookRangeBorder delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WorkbookRangeBorder with a source
     *
     * @param sourceWorkbookRangeBorder the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookRangeBorder> patchAsync(@Nonnull final WorkbookRangeBorder sourceWorkbookRangeBorder) {
        return sendAsync(HttpMethod.PATCH, sourceWorkbookRangeBorder);
    }

    /**
     * Patches this WorkbookRangeBorder with a source
     *
     * @param sourceWorkbookRangeBorder the source object with updates
     * @return the updated WorkbookRangeBorder
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookRangeBorder patch(@Nonnull final WorkbookRangeBorder sourceWorkbookRangeBorder) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookRangeBorder);
    }

    /**
     * Creates a WorkbookRangeBorder with a new object
     *
     * @param newWorkbookRangeBorder the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookRangeBorder> postAsync(@Nonnull final WorkbookRangeBorder newWorkbookRangeBorder) {
        return sendAsync(HttpMethod.POST, newWorkbookRangeBorder);
    }

    /**
     * Creates a WorkbookRangeBorder with a new object
     *
     * @param newWorkbookRangeBorder the new object to create
     * @return the created WorkbookRangeBorder
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookRangeBorder post(@Nonnull final WorkbookRangeBorder newWorkbookRangeBorder) throws ClientException {
        return send(HttpMethod.POST, newWorkbookRangeBorder);
    }

    /**
     * Creates a WorkbookRangeBorder with a new object
     *
     * @param newWorkbookRangeBorder the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookRangeBorder> putAsync(@Nonnull final WorkbookRangeBorder newWorkbookRangeBorder) {
        return sendAsync(HttpMethod.PUT, newWorkbookRangeBorder);
    }

    /**
     * Creates a WorkbookRangeBorder with a new object
     *
     * @param newWorkbookRangeBorder the object to create/update
     * @return the created WorkbookRangeBorder
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookRangeBorder put(@Nonnull final WorkbookRangeBorder newWorkbookRangeBorder) throws ClientException {
        return send(HttpMethod.PUT, newWorkbookRangeBorder);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public WorkbookRangeBorderRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public WorkbookRangeBorderRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

