// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;

import com.microsoft.graph.security.models.EdiscoveryReviewTag;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ediscovery Review Set Query Apply Tags Parameter Set.
 */
public class EdiscoveryReviewSetQueryApplyTagsParameterSet {
    /**
     * The tags To Add.
     * 
     */
    @SerializedName(value = "tagsToAdd", alternate = {"TagsToAdd"})
    @Expose
	@Nullable
    public java.util.List<EdiscoveryReviewTag> tagsToAdd;

    /**
     * The tags To Remove.
     * 
     */
    @SerializedName(value = "tagsToRemove", alternate = {"TagsToRemove"})
    @Expose
	@Nullable
    public java.util.List<EdiscoveryReviewTag> tagsToRemove;


    /**
     * Instiaciates a new EdiscoveryReviewSetQueryApplyTagsParameterSet
     */
    public EdiscoveryReviewSetQueryApplyTagsParameterSet() {}
    /**
     * Instiaciates a new EdiscoveryReviewSetQueryApplyTagsParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected EdiscoveryReviewSetQueryApplyTagsParameterSet(@Nonnull final EdiscoveryReviewSetQueryApplyTagsParameterSetBuilder builder) {
        this.tagsToAdd = builder.tagsToAdd;
        this.tagsToRemove = builder.tagsToRemove;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static EdiscoveryReviewSetQueryApplyTagsParameterSetBuilder newBuilder() {
        return new EdiscoveryReviewSetQueryApplyTagsParameterSetBuilder();
    }
    /**
     * Fluent builder for the EdiscoveryReviewSetQueryApplyTagsParameterSet
     */
    public static final class EdiscoveryReviewSetQueryApplyTagsParameterSetBuilder {
        /**
         * The tagsToAdd parameter value
         */
        @Nullable
        protected java.util.List<EdiscoveryReviewTag> tagsToAdd;
        /**
         * Sets the TagsToAdd
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public EdiscoveryReviewSetQueryApplyTagsParameterSetBuilder withTagsToAdd(@Nullable final java.util.List<EdiscoveryReviewTag> val) {
            this.tagsToAdd = val;
            return this;
        }
        /**
         * The tagsToRemove parameter value
         */
        @Nullable
        protected java.util.List<EdiscoveryReviewTag> tagsToRemove;
        /**
         * Sets the TagsToRemove
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public EdiscoveryReviewSetQueryApplyTagsParameterSetBuilder withTagsToRemove(@Nullable final java.util.List<EdiscoveryReviewTag> val) {
            this.tagsToRemove = val;
            return this;
        }
        /**
         * Instanciates a new EdiscoveryReviewSetQueryApplyTagsParameterSetBuilder
         */
        @Nullable
        protected EdiscoveryReviewSetQueryApplyTagsParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public EdiscoveryReviewSetQueryApplyTagsParameterSet build() {
            return new EdiscoveryReviewSetQueryApplyTagsParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.tagsToAdd != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("tagsToAdd", tagsToAdd));
        }
        if(this.tagsToRemove != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("tagsToRemove", tagsToRemove));
        }
        return result;
    }
}
