// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.EdiscoveryAddToReviewSetOperation;
import com.microsoft.graph.security.requests.EdiscoveryReviewSetWithReferenceRequestBuilder;
import com.microsoft.graph.security.requests.EdiscoverySearchWithReferenceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ediscovery Add To Review Set Operation Request.
 */
public class EdiscoveryAddToReviewSetOperationRequest extends BaseRequest<EdiscoveryAddToReviewSetOperation> {
	
    /**
     * The request for the EdiscoveryAddToReviewSetOperation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EdiscoveryAddToReviewSetOperationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EdiscoveryAddToReviewSetOperation.class);
    }

    /**
     * Gets the EdiscoveryAddToReviewSetOperation from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryAddToReviewSetOperation> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the EdiscoveryAddToReviewSetOperation from the service
     *
     * @return the EdiscoveryAddToReviewSetOperation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryAddToReviewSetOperation get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryAddToReviewSetOperation> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public EdiscoveryAddToReviewSetOperation delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this EdiscoveryAddToReviewSetOperation with a source
     *
     * @param sourceEdiscoveryAddToReviewSetOperation the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryAddToReviewSetOperation> patchAsync(@Nonnull final EdiscoveryAddToReviewSetOperation sourceEdiscoveryAddToReviewSetOperation) {
        return sendAsync(HttpMethod.PATCH, sourceEdiscoveryAddToReviewSetOperation);
    }

    /**
     * Patches this EdiscoveryAddToReviewSetOperation with a source
     *
     * @param sourceEdiscoveryAddToReviewSetOperation the source object with updates
     * @return the updated EdiscoveryAddToReviewSetOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryAddToReviewSetOperation patch(@Nonnull final EdiscoveryAddToReviewSetOperation sourceEdiscoveryAddToReviewSetOperation) throws ClientException {
        return send(HttpMethod.PATCH, sourceEdiscoveryAddToReviewSetOperation);
    }

    /**
     * Creates a EdiscoveryAddToReviewSetOperation with a new object
     *
     * @param newEdiscoveryAddToReviewSetOperation the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryAddToReviewSetOperation> postAsync(@Nonnull final EdiscoveryAddToReviewSetOperation newEdiscoveryAddToReviewSetOperation) {
        return sendAsync(HttpMethod.POST, newEdiscoveryAddToReviewSetOperation);
    }

    /**
     * Creates a EdiscoveryAddToReviewSetOperation with a new object
     *
     * @param newEdiscoveryAddToReviewSetOperation the new object to create
     * @return the created EdiscoveryAddToReviewSetOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryAddToReviewSetOperation post(@Nonnull final EdiscoveryAddToReviewSetOperation newEdiscoveryAddToReviewSetOperation) throws ClientException {
        return send(HttpMethod.POST, newEdiscoveryAddToReviewSetOperation);
    }

    /**
     * Creates a EdiscoveryAddToReviewSetOperation with a new object
     *
     * @param newEdiscoveryAddToReviewSetOperation the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryAddToReviewSetOperation> putAsync(@Nonnull final EdiscoveryAddToReviewSetOperation newEdiscoveryAddToReviewSetOperation) {
        return sendAsync(HttpMethod.PUT, newEdiscoveryAddToReviewSetOperation);
    }

    /**
     * Creates a EdiscoveryAddToReviewSetOperation with a new object
     *
     * @param newEdiscoveryAddToReviewSetOperation the object to create/update
     * @return the created EdiscoveryAddToReviewSetOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryAddToReviewSetOperation put(@Nonnull final EdiscoveryAddToReviewSetOperation newEdiscoveryAddToReviewSetOperation) throws ClientException {
        return send(HttpMethod.PUT, newEdiscoveryAddToReviewSetOperation);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public EdiscoveryAddToReviewSetOperationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public EdiscoveryAddToReviewSetOperationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

