// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.EdiscoveryCase;
import com.microsoft.graph.security.requests.EdiscoveryCustodianCollectionRequestBuilder;
import com.microsoft.graph.security.requests.EdiscoveryCustodianRequestBuilder;
import com.microsoft.graph.security.requests.EdiscoveryNoncustodialDataSourceCollectionRequestBuilder;
import com.microsoft.graph.security.requests.EdiscoveryNoncustodialDataSourceRequestBuilder;
import com.microsoft.graph.security.requests.CaseOperationCollectionRequestBuilder;
import com.microsoft.graph.security.requests.CaseOperationRequestBuilder;
import com.microsoft.graph.security.requests.EdiscoveryReviewSetCollectionRequestBuilder;
import com.microsoft.graph.security.requests.EdiscoveryReviewSetRequestBuilder;
import com.microsoft.graph.security.requests.EdiscoverySearchCollectionRequestBuilder;
import com.microsoft.graph.security.requests.EdiscoverySearchRequestBuilder;
import com.microsoft.graph.security.requests.EdiscoveryCaseSettingsRequestBuilder;
import com.microsoft.graph.security.requests.EdiscoveryReviewTagCollectionRequestBuilder;
import com.microsoft.graph.security.requests.EdiscoveryReviewTagRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ediscovery Case Request.
 */
public class EdiscoveryCaseRequest extends BaseRequest<EdiscoveryCase> {
	
    /**
     * The request for the EdiscoveryCase
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EdiscoveryCaseRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EdiscoveryCase.class);
    }

    /**
     * Gets the EdiscoveryCase from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryCase> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the EdiscoveryCase from the service
     *
     * @return the EdiscoveryCase from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryCase get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryCase> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public EdiscoveryCase delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this EdiscoveryCase with a source
     *
     * @param sourceEdiscoveryCase the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryCase> patchAsync(@Nonnull final EdiscoveryCase sourceEdiscoveryCase) {
        return sendAsync(HttpMethod.PATCH, sourceEdiscoveryCase);
    }

    /**
     * Patches this EdiscoveryCase with a source
     *
     * @param sourceEdiscoveryCase the source object with updates
     * @return the updated EdiscoveryCase
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryCase patch(@Nonnull final EdiscoveryCase sourceEdiscoveryCase) throws ClientException {
        return send(HttpMethod.PATCH, sourceEdiscoveryCase);
    }

    /**
     * Creates a EdiscoveryCase with a new object
     *
     * @param newEdiscoveryCase the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryCase> postAsync(@Nonnull final EdiscoveryCase newEdiscoveryCase) {
        return sendAsync(HttpMethod.POST, newEdiscoveryCase);
    }

    /**
     * Creates a EdiscoveryCase with a new object
     *
     * @param newEdiscoveryCase the new object to create
     * @return the created EdiscoveryCase
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryCase post(@Nonnull final EdiscoveryCase newEdiscoveryCase) throws ClientException {
        return send(HttpMethod.POST, newEdiscoveryCase);
    }

    /**
     * Creates a EdiscoveryCase with a new object
     *
     * @param newEdiscoveryCase the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryCase> putAsync(@Nonnull final EdiscoveryCase newEdiscoveryCase) {
        return sendAsync(HttpMethod.PUT, newEdiscoveryCase);
    }

    /**
     * Creates a EdiscoveryCase with a new object
     *
     * @param newEdiscoveryCase the object to create/update
     * @return the created EdiscoveryCase
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryCase put(@Nonnull final EdiscoveryCase newEdiscoveryCase) throws ClientException {
        return send(HttpMethod.PUT, newEdiscoveryCase);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public EdiscoveryCaseRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public EdiscoveryCaseRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

