// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.EdiscoveryReviewSet;
import com.microsoft.graph.security.models.EdiscoverySearch;
import com.microsoft.graph.security.models.AdditionalDataOptions;
import java.util.EnumSet;
import com.microsoft.graph.security.requests.EdiscoveryReviewSetQueryCollectionRequestBuilder;
import com.microsoft.graph.security.requests.EdiscoveryReviewSetQueryRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ediscovery Review Set Request.
 */
public class EdiscoveryReviewSetRequest extends BaseRequest<EdiscoveryReviewSet> {
	
    /**
     * The request for the EdiscoveryReviewSet
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EdiscoveryReviewSetRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EdiscoveryReviewSet.class);
    }

    /**
     * Gets the EdiscoveryReviewSet from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryReviewSet> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the EdiscoveryReviewSet from the service
     *
     * @return the EdiscoveryReviewSet from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryReviewSet get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryReviewSet> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public EdiscoveryReviewSet delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this EdiscoveryReviewSet with a source
     *
     * @param sourceEdiscoveryReviewSet the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryReviewSet> patchAsync(@Nonnull final EdiscoveryReviewSet sourceEdiscoveryReviewSet) {
        return sendAsync(HttpMethod.PATCH, sourceEdiscoveryReviewSet);
    }

    /**
     * Patches this EdiscoveryReviewSet with a source
     *
     * @param sourceEdiscoveryReviewSet the source object with updates
     * @return the updated EdiscoveryReviewSet
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryReviewSet patch(@Nonnull final EdiscoveryReviewSet sourceEdiscoveryReviewSet) throws ClientException {
        return send(HttpMethod.PATCH, sourceEdiscoveryReviewSet);
    }

    /**
     * Creates a EdiscoveryReviewSet with a new object
     *
     * @param newEdiscoveryReviewSet the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryReviewSet> postAsync(@Nonnull final EdiscoveryReviewSet newEdiscoveryReviewSet) {
        return sendAsync(HttpMethod.POST, newEdiscoveryReviewSet);
    }

    /**
     * Creates a EdiscoveryReviewSet with a new object
     *
     * @param newEdiscoveryReviewSet the new object to create
     * @return the created EdiscoveryReviewSet
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryReviewSet post(@Nonnull final EdiscoveryReviewSet newEdiscoveryReviewSet) throws ClientException {
        return send(HttpMethod.POST, newEdiscoveryReviewSet);
    }

    /**
     * Creates a EdiscoveryReviewSet with a new object
     *
     * @param newEdiscoveryReviewSet the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryReviewSet> putAsync(@Nonnull final EdiscoveryReviewSet newEdiscoveryReviewSet) {
        return sendAsync(HttpMethod.PUT, newEdiscoveryReviewSet);
    }

    /**
     * Creates a EdiscoveryReviewSet with a new object
     *
     * @param newEdiscoveryReviewSet the object to create/update
     * @return the created EdiscoveryReviewSet
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryReviewSet put(@Nonnull final EdiscoveryReviewSet newEdiscoveryReviewSet) throws ClientException {
        return send(HttpMethod.PUT, newEdiscoveryReviewSet);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public EdiscoveryReviewSetRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public EdiscoveryReviewSetRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

