// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.termstore.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.termstore.models.Term;
import com.microsoft.graph.termstore.requests.TermCollectionRequestBuilder;
import com.microsoft.graph.termstore.requests.TermRequestBuilder;
import com.microsoft.graph.termstore.requests.RelationCollectionRequestBuilder;
import com.microsoft.graph.termstore.requests.RelationRequestBuilder;
import com.microsoft.graph.termstore.requests.SetWithReferenceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Term Request.
 */
public class TermRequest extends BaseRequest<Term> {
	
    /**
     * The request for the Term
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TermRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Term.class);
    }

    /**
     * Gets the Term from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Term> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Term from the service
     *
     * @return the Term from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Term get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Term> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Term delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Term with a source
     *
     * @param sourceTerm the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Term> patchAsync(@Nonnull final Term sourceTerm) {
        return sendAsync(HttpMethod.PATCH, sourceTerm);
    }

    /**
     * Patches this Term with a source
     *
     * @param sourceTerm the source object with updates
     * @return the updated Term
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Term patch(@Nonnull final Term sourceTerm) throws ClientException {
        return send(HttpMethod.PATCH, sourceTerm);
    }

    /**
     * Creates a Term with a new object
     *
     * @param newTerm the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Term> postAsync(@Nonnull final Term newTerm) {
        return sendAsync(HttpMethod.POST, newTerm);
    }

    /**
     * Creates a Term with a new object
     *
     * @param newTerm the new object to create
     * @return the created Term
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Term post(@Nonnull final Term newTerm) throws ClientException {
        return send(HttpMethod.POST, newTerm);
    }

    /**
     * Creates a Term with a new object
     *
     * @param newTerm the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Term> putAsync(@Nonnull final Term newTerm) {
        return sendAsync(HttpMethod.PUT, newTerm);
    }

    /**
     * Creates a Term with a new object
     *
     * @param newTerm the object to create/update
     * @return the created Term
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Term put(@Nonnull final Term newTerm) throws ClientException {
        return send(HttpMethod.PUT, newTerm);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public TermRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public TermRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

