/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.identitygovernance.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.identitygovernance.models.TaskReport;
import com.microsoft.graph.identitygovernance.requests.TaskReportCollectionPage;
import com.microsoft.graph.identitygovernance.requests.TaskReportCollectionRequestBuilder;
import com.microsoft.graph.identitygovernance.requests.TaskReportCollectionResponse;
import com.microsoft.graph.identitygovernance.requests.TaskReportRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TaskReportCollectionRequest
extends BaseEntityCollectionRequest<TaskReport, TaskReportCollectionResponse, TaskReportCollectionPage> {
    public TaskReportCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TaskReportCollectionResponse.class, TaskReportCollectionPage.class, TaskReportCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<TaskReport> postAsync(@Nonnull TaskReport newTaskReport) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TaskReportRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newTaskReport);
    }

    @Nonnull
    public TaskReport post(@Nonnull TaskReport newTaskReport) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TaskReportRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newTaskReport);
    }

    @Nonnull
    public TaskReportCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public TaskReportCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public TaskReportCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public TaskReportCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public TaskReportCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public TaskReportCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public TaskReportCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public TaskReportCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public TaskReportCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

