/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.identitygovernance.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.identitygovernance.models.Task;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TaskRequest
extends BaseRequest<Task> {
    public TaskRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Task.class);
    }

    @Nonnull
    public CompletableFuture<Task> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public Task get() throws ClientException {
        return (Task)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<Task> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public Task delete() throws ClientException {
        return (Task)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<Task> patchAsync(@Nonnull Task sourceTask) {
        return this.sendAsync(HttpMethod.PATCH, sourceTask);
    }

    @Nullable
    public Task patch(@Nonnull Task sourceTask) throws ClientException {
        return (Task)this.send(HttpMethod.PATCH, sourceTask);
    }

    @Nonnull
    public CompletableFuture<Task> postAsync(@Nonnull Task newTask) {
        return this.sendAsync(HttpMethod.POST, newTask);
    }

    @Nullable
    public Task post(@Nonnull Task newTask) throws ClientException {
        return (Task)this.send(HttpMethod.POST, newTask);
    }

    @Nonnull
    public CompletableFuture<Task> putAsync(@Nonnull Task newTask) {
        return this.sendAsync(HttpMethod.PUT, newTask);
    }

    @Nullable
    public Task put(@Nonnull Task newTask) throws ClientException {
        return (Task)this.send(HttpMethod.PUT, newTask);
    }

    @Nonnull
    public TaskRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public TaskRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

