// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.Presence;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Cloud Communications Get Presences By User Id Parameter Set.
 */
public class CloudCommunicationsGetPresencesByUserIdParameterSet {
    /**
     * The ids.
     * 
     */
    @SerializedName(value = "ids", alternate = {"Ids"})
    @Expose
	@Nullable
    public java.util.List<String> ids;


    /**
     * Instiaciates a new CloudCommunicationsGetPresencesByUserIdParameterSet
     */
    public CloudCommunicationsGetPresencesByUserIdParameterSet() {}
    /**
     * Instiaciates a new CloudCommunicationsGetPresencesByUserIdParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected CloudCommunicationsGetPresencesByUserIdParameterSet(@Nonnull final CloudCommunicationsGetPresencesByUserIdParameterSetBuilder builder) {
        this.ids = builder.ids;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static CloudCommunicationsGetPresencesByUserIdParameterSetBuilder newBuilder() {
        return new CloudCommunicationsGetPresencesByUserIdParameterSetBuilder();
    }
    /**
     * Fluent builder for the CloudCommunicationsGetPresencesByUserIdParameterSet
     */
    public static final class CloudCommunicationsGetPresencesByUserIdParameterSetBuilder {
        /**
         * The ids parameter value
         */
        @Nullable
        protected java.util.List<String> ids;
        /**
         * Sets the Ids
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public CloudCommunicationsGetPresencesByUserIdParameterSetBuilder withIds(@Nullable final java.util.List<String> val) {
            this.ids = val;
            return this;
        }
        /**
         * Instanciates a new CloudCommunicationsGetPresencesByUserIdParameterSetBuilder
         */
        @Nullable
        protected CloudCommunicationsGetPresencesByUserIdParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public CloudCommunicationsGetPresencesByUserIdParameterSet build() {
            return new CloudCommunicationsGetPresencesByUserIdParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.ids != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("ids", ids));
        }
        return result;
    }
}
