// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.Post;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Conversation Thread Reply Parameter Set.
 */
public class ConversationThreadReplyParameterSet {
    /**
     * The post.
     * 
     */
    @SerializedName(value = "post", alternate = {"Post"})
    @Expose
	@Nullable
    public Post post;


    /**
     * Instiaciates a new ConversationThreadReplyParameterSet
     */
    public ConversationThreadReplyParameterSet() {}
    /**
     * Instiaciates a new ConversationThreadReplyParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected ConversationThreadReplyParameterSet(@Nonnull final ConversationThreadReplyParameterSetBuilder builder) {
        this.post = builder.post;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static ConversationThreadReplyParameterSetBuilder newBuilder() {
        return new ConversationThreadReplyParameterSetBuilder();
    }
    /**
     * Fluent builder for the ConversationThreadReplyParameterSet
     */
    public static final class ConversationThreadReplyParameterSetBuilder {
        /**
         * The post parameter value
         */
        @Nullable
        protected Post post;
        /**
         * Sets the Post
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ConversationThreadReplyParameterSetBuilder withPost(@Nullable final Post val) {
            this.post = val;
            return this;
        }
        /**
         * Instanciates a new ConversationThreadReplyParameterSetBuilder
         */
        @Nullable
        protected ConversationThreadReplyParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public ConversationThreadReplyParameterSet build() {
            return new ConversationThreadReplyParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.post != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("post", post));
        }
        return result;
    }
}
