// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Management Settings.
 */
public class DeviceManagementSettings implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Device Compliance Checkin Threshold Days.
     * The number of days a device is allowed to go without checking in to remain compliant.
     */
    @SerializedName(value = "deviceComplianceCheckinThresholdDays", alternate = {"DeviceComplianceCheckinThresholdDays"})
    @Expose
	@Nullable
    public Integer deviceComplianceCheckinThresholdDays;

    /**
     * The Is Scheduled Action Enabled.
     * Is feature enabled or not for scheduled action for rule.
     */
    @SerializedName(value = "isScheduledActionEnabled", alternate = {"IsScheduledActionEnabled"})
    @Expose
	@Nullable
    public Boolean isScheduledActionEnabled;

    /**
     * The Secure By Default.
     * Device should be noncompliant when there is no compliance policy targeted when this is true
     */
    @SerializedName(value = "secureByDefault", alternate = {"SecureByDefault"})
    @Expose
	@Nullable
    public Boolean secureByDefault;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
