// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.EducationFeedback;
import com.microsoft.graph.models.EducationOutcome;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Education Feedback Outcome.
 */
public class EducationFeedbackOutcome extends EducationOutcome implements IJsonBackedObject {


    /**
     * The Feedback.
     * Teacher's written feedback to the student.
     */
    @SerializedName(value = "feedback", alternate = {"Feedback"})
    @Expose
	@Nullable
    public EducationFeedback feedback;

    /**
     * The Published Feedback.
     * A copy of the feedback property that is made when the grade is released to the student.
     */
    @SerializedName(value = "publishedFeedback", alternate = {"PublishedFeedback"})
    @Expose
	@Nullable
    public EducationFeedback publishedFeedback;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
