// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.AppConfigurationSettingItem;
import com.microsoft.graph.models.ManagedDeviceMobileAppConfiguration;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ios Mobile App Configuration.
 */
public class IosMobileAppConfiguration extends ManagedDeviceMobileAppConfiguration implements IJsonBackedObject {


    /**
     * The Encoded Setting Xml.
     * mdm app configuration Base64 binary.
     */
    @SerializedName(value = "encodedSettingXml", alternate = {"EncodedSettingXml"})
    @Expose
	@Nullable
    public byte[] encodedSettingXml;

    /**
     * The Settings.
     * app configuration setting items.
     */
    @SerializedName(value = "settings", alternate = {"Settings"})
    @Expose
	@Nullable
    public java.util.List<AppConfigurationSettingItem> settings;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
