// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Managed Device Windows Defender Scan Parameter Set.
 */
public class ManagedDeviceWindowsDefenderScanParameterSet {
    /**
     * The quick Scan.
     * 
     */
    @SerializedName(value = "quickScan", alternate = {"QuickScan"})
    @Expose
	@Nullable
    public Boolean quickScan;


    /**
     * Instiaciates a new ManagedDeviceWindowsDefenderScanParameterSet
     */
    public ManagedDeviceWindowsDefenderScanParameterSet() {}
    /**
     * Instiaciates a new ManagedDeviceWindowsDefenderScanParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected ManagedDeviceWindowsDefenderScanParameterSet(@Nonnull final ManagedDeviceWindowsDefenderScanParameterSetBuilder builder) {
        this.quickScan = builder.quickScan;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static ManagedDeviceWindowsDefenderScanParameterSetBuilder newBuilder() {
        return new ManagedDeviceWindowsDefenderScanParameterSetBuilder();
    }
    /**
     * Fluent builder for the ManagedDeviceWindowsDefenderScanParameterSet
     */
    public static final class ManagedDeviceWindowsDefenderScanParameterSetBuilder {
        /**
         * The quickScan parameter value
         */
        @Nullable
        protected Boolean quickScan;
        /**
         * Sets the QuickScan
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ManagedDeviceWindowsDefenderScanParameterSetBuilder withQuickScan(@Nullable final Boolean val) {
            this.quickScan = val;
            return this;
        }
        /**
         * Instanciates a new ManagedDeviceWindowsDefenderScanParameterSetBuilder
         */
        @Nullable
        protected ManagedDeviceWindowsDefenderScanParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public ManagedDeviceWindowsDefenderScanParameterSet build() {
            return new ManagedDeviceWindowsDefenderScanParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.quickScan != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("quickScan", quickScan));
        }
        return result;
    }
}
