// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.MobileAppAssignment;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Mobile App Assign Parameter Set.
 */
public class MobileAppAssignParameterSet {
    /**
     * The mobile App Assignments.
     * 
     */
    @SerializedName(value = "mobileAppAssignments", alternate = {"MobileAppAssignments"})
    @Expose
	@Nullable
    public java.util.List<MobileAppAssignment> mobileAppAssignments;


    /**
     * Instiaciates a new MobileAppAssignParameterSet
     */
    public MobileAppAssignParameterSet() {}
    /**
     * Instiaciates a new MobileAppAssignParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected MobileAppAssignParameterSet(@Nonnull final MobileAppAssignParameterSetBuilder builder) {
        this.mobileAppAssignments = builder.mobileAppAssignments;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static MobileAppAssignParameterSetBuilder newBuilder() {
        return new MobileAppAssignParameterSetBuilder();
    }
    /**
     * Fluent builder for the MobileAppAssignParameterSet
     */
    public static final class MobileAppAssignParameterSetBuilder {
        /**
         * The mobileAppAssignments parameter value
         */
        @Nullable
        protected java.util.List<MobileAppAssignment> mobileAppAssignments;
        /**
         * Sets the MobileAppAssignments
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public MobileAppAssignParameterSetBuilder withMobileAppAssignments(@Nullable final java.util.List<MobileAppAssignment> val) {
            this.mobileAppAssignments = val;
            return this;
        }
        /**
         * Instanciates a new MobileAppAssignParameterSetBuilder
         */
        @Nullable
        protected MobileAppAssignParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public MobileAppAssignParameterSet build() {
            return new MobileAppAssignParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.mobileAppAssignments != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("mobileAppAssignments", mobileAppAssignments));
        }
        return result;
    }
}
