// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.PrintJobStateDetail;
import com.microsoft.graph.models.PrintJobProcessingState;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Print Job Status.
 */
public class PrintJobStatus implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Description.
     * A human-readable description of the print job's current processing state. Read-only.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Details.
     * Additional details for print job state. Valid values are described in the following table. Read-only.
     */
    @SerializedName(value = "details", alternate = {"Details"})
    @Expose
	@Nullable
    public java.util.List<PrintJobStateDetail> details;

    /**
     * The Is Acquired By Printer.
     * True if the job was acknowledged by a printer; false otherwise. Read-only.
     */
    @SerializedName(value = "isAcquiredByPrinter", alternate = {"IsAcquiredByPrinter"})
    @Expose
	@Nullable
    public Boolean isAcquiredByPrinter;

    /**
     * The State.
     * The print job's current processing state. Valid values are described in the following table. Read-only.
     */
    @SerializedName(value = "state", alternate = {"State"})
    @Expose
	@Nullable
    public PrintJobProcessingState state;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
