// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Service Principal Remove Key Parameter Set.
 */
public class ServicePrincipalRemoveKeyParameterSet {
    /**
     * The key Id.
     * 
     */
    @SerializedName(value = "keyId", alternate = {"KeyId"})
    @Expose
	@Nullable
    public java.util.UUID keyId;

    /**
     * The proof.
     * 
     */
    @SerializedName(value = "proof", alternate = {"Proof"})
    @Expose
	@Nullable
    public String proof;


    /**
     * Instiaciates a new ServicePrincipalRemoveKeyParameterSet
     */
    public ServicePrincipalRemoveKeyParameterSet() {}
    /**
     * Instiaciates a new ServicePrincipalRemoveKeyParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected ServicePrincipalRemoveKeyParameterSet(@Nonnull final ServicePrincipalRemoveKeyParameterSetBuilder builder) {
        this.keyId = builder.keyId;
        this.proof = builder.proof;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static ServicePrincipalRemoveKeyParameterSetBuilder newBuilder() {
        return new ServicePrincipalRemoveKeyParameterSetBuilder();
    }
    /**
     * Fluent builder for the ServicePrincipalRemoveKeyParameterSet
     */
    public static final class ServicePrincipalRemoveKeyParameterSetBuilder {
        /**
         * The keyId parameter value
         */
        @Nullable
        protected java.util.UUID keyId;
        /**
         * Sets the KeyId
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ServicePrincipalRemoveKeyParameterSetBuilder withKeyId(@Nullable final java.util.UUID val) {
            this.keyId = val;
            return this;
        }
        /**
         * The proof parameter value
         */
        @Nullable
        protected String proof;
        /**
         * Sets the Proof
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ServicePrincipalRemoveKeyParameterSetBuilder withProof(@Nullable final String val) {
            this.proof = val;
            return this;
        }
        /**
         * Instanciates a new ServicePrincipalRemoveKeyParameterSetBuilder
         */
        @Nullable
        protected ServicePrincipalRemoveKeyParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public ServicePrincipalRemoveKeyParameterSet build() {
            return new ServicePrincipalRemoveKeyParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.keyId != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("keyId", keyId));
        }
        if(this.proof != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("proof", proof));
        }
        return result;
    }
}
