// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Export Personal Data Parameter Set.
 */
public class UserExportPersonalDataParameterSet {
    /**
     * The storage Location.
     * 
     */
    @SerializedName(value = "storageLocation", alternate = {"StorageLocation"})
    @Expose
	@Nullable
    public String storageLocation;


    /**
     * Instiaciates a new UserExportPersonalDataParameterSet
     */
    public UserExportPersonalDataParameterSet() {}
    /**
     * Instiaciates a new UserExportPersonalDataParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected UserExportPersonalDataParameterSet(@Nonnull final UserExportPersonalDataParameterSetBuilder builder) {
        this.storageLocation = builder.storageLocation;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static UserExportPersonalDataParameterSetBuilder newBuilder() {
        return new UserExportPersonalDataParameterSetBuilder();
    }
    /**
     * Fluent builder for the UserExportPersonalDataParameterSet
     */
    public static final class UserExportPersonalDataParameterSetBuilder {
        /**
         * The storageLocation parameter value
         */
        @Nullable
        protected String storageLocation;
        /**
         * Sets the StorageLocation
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public UserExportPersonalDataParameterSetBuilder withStorageLocation(@Nullable final String val) {
            this.storageLocation = val;
            return this;
        }
        /**
         * Instanciates a new UserExportPersonalDataParameterSetBuilder
         */
        @Nullable
        protected UserExportPersonalDataParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public UserExportPersonalDataParameterSet build() {
            return new UserExportPersonalDataParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.storageLocation != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("storageLocation", storageLocation));
        }
        return result;
    }
}
