// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookSessionInfo;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Create Session Parameter Set.
 */
public class WorkbookCreateSessionParameterSet {
    /**
     * The persist Changes.
     * 
     */
    @SerializedName(value = "persistChanges", alternate = {"PersistChanges"})
    @Expose
	@Nullable
    public Boolean persistChanges;


    /**
     * Instiaciates a new WorkbookCreateSessionParameterSet
     */
    public WorkbookCreateSessionParameterSet() {}
    /**
     * Instiaciates a new WorkbookCreateSessionParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookCreateSessionParameterSet(@Nonnull final WorkbookCreateSessionParameterSetBuilder builder) {
        this.persistChanges = builder.persistChanges;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookCreateSessionParameterSetBuilder newBuilder() {
        return new WorkbookCreateSessionParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookCreateSessionParameterSet
     */
    public static final class WorkbookCreateSessionParameterSetBuilder {
        /**
         * The persistChanges parameter value
         */
        @Nullable
        protected Boolean persistChanges;
        /**
         * Sets the PersistChanges
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookCreateSessionParameterSetBuilder withPersistChanges(@Nullable final Boolean val) {
            this.persistChanges = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookCreateSessionParameterSetBuilder
         */
        @Nullable
        protected WorkbookCreateSessionParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookCreateSessionParameterSet build() {
            return new WorkbookCreateSessionParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.persistChanges != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("persistChanges", persistChanges));
        }
        return result;
    }
}
