// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Binom_Dist Parameter Set.
 */
public class WorkbookFunctionsBinom_DistParameterSet {
    /**
     * The number S.
     * 
     */
    @SerializedName(value = "numberS", alternate = {"NumberS"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement numberS;

    /**
     * The trials.
     * 
     */
    @SerializedName(value = "trials", alternate = {"Trials"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement trials;

    /**
     * The probability S.
     * 
     */
    @SerializedName(value = "probabilityS", alternate = {"ProbabilityS"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement probabilityS;

    /**
     * The cumulative.
     * 
     */
    @SerializedName(value = "cumulative", alternate = {"Cumulative"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement cumulative;


    /**
     * Instiaciates a new WorkbookFunctionsBinom_DistParameterSet
     */
    public WorkbookFunctionsBinom_DistParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsBinom_DistParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsBinom_DistParameterSet(@Nonnull final WorkbookFunctionsBinom_DistParameterSetBuilder builder) {
        this.numberS = builder.numberS;
        this.trials = builder.trials;
        this.probabilityS = builder.probabilityS;
        this.cumulative = builder.cumulative;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsBinom_DistParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsBinom_DistParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsBinom_DistParameterSet
     */
    public static final class WorkbookFunctionsBinom_DistParameterSetBuilder {
        /**
         * The numberS parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement numberS;
        /**
         * Sets the NumberS
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsBinom_DistParameterSetBuilder withNumberS(@Nullable final com.google.gson.JsonElement val) {
            this.numberS = val;
            return this;
        }
        /**
         * The trials parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement trials;
        /**
         * Sets the Trials
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsBinom_DistParameterSetBuilder withTrials(@Nullable final com.google.gson.JsonElement val) {
            this.trials = val;
            return this;
        }
        /**
         * The probabilityS parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement probabilityS;
        /**
         * Sets the ProbabilityS
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsBinom_DistParameterSetBuilder withProbabilityS(@Nullable final com.google.gson.JsonElement val) {
            this.probabilityS = val;
            return this;
        }
        /**
         * The cumulative parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement cumulative;
        /**
         * Sets the Cumulative
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsBinom_DistParameterSetBuilder withCumulative(@Nullable final com.google.gson.JsonElement val) {
            this.cumulative = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsBinom_DistParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsBinom_DistParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsBinom_DistParameterSet build() {
            return new WorkbookFunctionsBinom_DistParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.numberS != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("numberS", numberS));
        }
        if(this.trials != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("trials", trials));
        }
        if(this.probabilityS != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("probabilityS", probabilityS));
        }
        if(this.cumulative != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("cumulative", cumulative));
        }
        return result;
    }
}
