// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Iso Week Num Parameter Set.
 */
public class WorkbookFunctionsIsoWeekNumParameterSet {
    /**
     * The date.
     * 
     */
    @SerializedName(value = "date", alternate = {"Date"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement date;


    /**
     * Instiaciates a new WorkbookFunctionsIsoWeekNumParameterSet
     */
    public WorkbookFunctionsIsoWeekNumParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsIsoWeekNumParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsIsoWeekNumParameterSet(@Nonnull final WorkbookFunctionsIsoWeekNumParameterSetBuilder builder) {
        this.date = builder.date;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsIsoWeekNumParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsIsoWeekNumParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsIsoWeekNumParameterSet
     */
    public static final class WorkbookFunctionsIsoWeekNumParameterSetBuilder {
        /**
         * The date parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement date;
        /**
         * Sets the Date
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsIsoWeekNumParameterSetBuilder withDate(@Nullable final com.google.gson.JsonElement val) {
            this.date = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsIsoWeekNumParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsIsoWeekNumParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsIsoWeekNumParameterSet build() {
            return new WorkbookFunctionsIsoWeekNumParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.date != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("date", date));
        }
        return result;
    }
}
