// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Mirr Parameter Set.
 */
public class WorkbookFunctionsMirrParameterSet {
    /**
     * The values.
     * 
     */
    @SerializedName(value = "values", alternate = {"Values"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement values;

    /**
     * The finance Rate.
     * 
     */
    @SerializedName(value = "financeRate", alternate = {"FinanceRate"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement financeRate;

    /**
     * The reinvest Rate.
     * 
     */
    @SerializedName(value = "reinvestRate", alternate = {"ReinvestRate"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement reinvestRate;


    /**
     * Instiaciates a new WorkbookFunctionsMirrParameterSet
     */
    public WorkbookFunctionsMirrParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsMirrParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsMirrParameterSet(@Nonnull final WorkbookFunctionsMirrParameterSetBuilder builder) {
        this.values = builder.values;
        this.financeRate = builder.financeRate;
        this.reinvestRate = builder.reinvestRate;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsMirrParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsMirrParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsMirrParameterSet
     */
    public static final class WorkbookFunctionsMirrParameterSetBuilder {
        /**
         * The values parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement values;
        /**
         * Sets the Values
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsMirrParameterSetBuilder withValues(@Nullable final com.google.gson.JsonElement val) {
            this.values = val;
            return this;
        }
        /**
         * The financeRate parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement financeRate;
        /**
         * Sets the FinanceRate
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsMirrParameterSetBuilder withFinanceRate(@Nullable final com.google.gson.JsonElement val) {
            this.financeRate = val;
            return this;
        }
        /**
         * The reinvestRate parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement reinvestRate;
        /**
         * Sets the ReinvestRate
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsMirrParameterSetBuilder withReinvestRate(@Nullable final com.google.gson.JsonElement val) {
            this.reinvestRate = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsMirrParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsMirrParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsMirrParameterSet build() {
            return new WorkbookFunctionsMirrParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.values != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("values", values));
        }
        if(this.financeRate != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("financeRate", financeRate));
        }
        if(this.reinvestRate != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("reinvestRate", reinvestRate));
        }
        return result;
    }
}
