// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Rept Parameter Set.
 */
public class WorkbookFunctionsReptParameterSet {
    /**
     * The text.
     * 
     */
    @SerializedName(value = "text", alternate = {"Text"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement text;

    /**
     * The number Times.
     * 
     */
    @SerializedName(value = "numberTimes", alternate = {"NumberTimes"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement numberTimes;


    /**
     * Instiaciates a new WorkbookFunctionsReptParameterSet
     */
    public WorkbookFunctionsReptParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsReptParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsReptParameterSet(@Nonnull final WorkbookFunctionsReptParameterSetBuilder builder) {
        this.text = builder.text;
        this.numberTimes = builder.numberTimes;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsReptParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsReptParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsReptParameterSet
     */
    public static final class WorkbookFunctionsReptParameterSetBuilder {
        /**
         * The text parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement text;
        /**
         * Sets the Text
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsReptParameterSetBuilder withText(@Nullable final com.google.gson.JsonElement val) {
            this.text = val;
            return this;
        }
        /**
         * The numberTimes parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement numberTimes;
        /**
         * Sets the NumberTimes
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsReptParameterSetBuilder withNumberTimes(@Nullable final com.google.gson.JsonElement val) {
            this.numberTimes = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsReptParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsReptParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsReptParameterSet build() {
            return new WorkbookFunctionsReptParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.text != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("text", text));
        }
        if(this.numberTimes != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("numberTimes", numberTimes));
        }
        return result;
    }
}
