// Template Source: BaseMethodCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AccessPackageFilterByCurrentUserOptions;
import com.microsoft.graph.models.AccessPackage;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.AccessPackageFilterByCurrentUserCollectionRequestBuilder;
import com.microsoft.graph.requests.AccessPackageFilterByCurrentUserCollectionRequest;
import com.microsoft.graph.requests.AccessPackageFilterByCurrentUserCollectionResponse;
import com.microsoft.graph.models.AccessPackageFilterByCurrentUserParameterSet;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseFunctionCollectionRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Package Filter By Current User Collection Request Builder.
 */
public class AccessPackageFilterByCurrentUserCollectionRequestBuilder extends BaseFunctionCollectionRequestBuilder<AccessPackage, AccessPackageFilterByCurrentUserCollectionRequestBuilder, AccessPackageFilterByCurrentUserCollectionResponse, AccessPackageFilterByCurrentUserCollectionPage, AccessPackageFilterByCurrentUserCollectionRequest> {

    /**
     * The request builder for this collection of AccessPackage
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AccessPackageFilterByCurrentUserCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AccessPackageFilterByCurrentUserCollectionRequestBuilder.class, AccessPackageFilterByCurrentUserCollectionRequest.class);
    }
    /**
     * The request builder for this collection of AccessPackage
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public AccessPackageFilterByCurrentUserCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final AccessPackageFilterByCurrentUserParameterSet parameters) {
        super(requestUrl, client, requestOptions, AccessPackageFilterByCurrentUserCollectionRequestBuilder.class, AccessPackageFilterByCurrentUserCollectionRequest.class);
        if(parameters != null) {
            functionOptions = parameters.getFunctionOptions();
        }
    }
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the AccessPackageFilterByCurrentUserCollectionRequest instance
     */
    @Override
    @Nonnull
    public AccessPackageFilterByCurrentUserCollectionRequest buildRequest(@Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final AccessPackageFilterByCurrentUserCollectionRequest request = super.buildRequest(requestOptions);
        if(functionOptions != null) {    
            for (com.microsoft.graph.options.FunctionOption option : functionOptions) {
                request.addFunctionOption(option);
            }
        }
        return request;
    }
}
