// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Agreement;
import com.microsoft.graph.requests.AgreementAcceptanceCollectionRequestBuilder;
import com.microsoft.graph.requests.AgreementAcceptanceRequestBuilder;
import com.microsoft.graph.requests.AgreementFileRequestBuilder;
import com.microsoft.graph.requests.AgreementFileLocalizationCollectionRequestBuilder;
import com.microsoft.graph.requests.AgreementFileLocalizationRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Agreement Request Builder.
 */
public class AgreementRequestBuilder extends BaseRequestBuilder<Agreement> {

    /**
     * The request builder for the Agreement
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AgreementRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the AgreementRequest instance
     */
    @Nonnull
    public AgreementRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the AgreementRequest instance
     */
    @Nonnull
    public AgreementRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.AgreementRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the AgreementAcceptance collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public AgreementAcceptanceCollectionRequestBuilder acceptances() {
        return new AgreementAcceptanceCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("acceptances"), getClient(), null);
    }

    /**
     * Gets a request builder for the AgreementAcceptance item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public AgreementAcceptanceRequestBuilder acceptances(@Nonnull final String id) {
        return new AgreementAcceptanceRequestBuilder(getRequestUrlWithAdditionalSegment("acceptances") + "/" + id, getClient(), null);
    }

    /**
     * Gets the request builder for AgreementFile
     *
     * @return the AgreementFileRequestBuilder instance
     */
    @Nonnull
    public AgreementFileRequestBuilder file() {
        return new AgreementFileRequestBuilder(getRequestUrlWithAdditionalSegment("file"), getClient(), null);
    }
    /**
     *  Gets a request builder for the AgreementFileLocalization collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public AgreementFileLocalizationCollectionRequestBuilder files() {
        return new AgreementFileLocalizationCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("files"), getClient(), null);
    }

    /**
     * Gets a request builder for the AgreementFileLocalization item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public AgreementFileLocalizationRequestBuilder files(@Nonnull final String id) {
        return new AgreementFileLocalizationRequestBuilder(getRequestUrlWithAdditionalSegment("files") + "/" + id, getClient(), null);
    }
}
