// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AuthenticationMethod;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Authentication Method Request.
 */
public class AuthenticationMethodRequest extends BaseRequest<AuthenticationMethod> {
	
    /**
     * The request for the AuthenticationMethod
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public AuthenticationMethodRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends AuthenticationMethod> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the AuthenticationMethod
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AuthenticationMethodRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AuthenticationMethod.class);
    }

    /**
     * Gets the AuthenticationMethod from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationMethod> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AuthenticationMethod from the service
     *
     * @return the AuthenticationMethod from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AuthenticationMethod get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationMethod> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AuthenticationMethod delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AuthenticationMethod with a source
     *
     * @param sourceAuthenticationMethod the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationMethod> patchAsync(@Nonnull final AuthenticationMethod sourceAuthenticationMethod) {
        return sendAsync(HttpMethod.PATCH, sourceAuthenticationMethod);
    }

    /**
     * Patches this AuthenticationMethod with a source
     *
     * @param sourceAuthenticationMethod the source object with updates
     * @return the updated AuthenticationMethod
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AuthenticationMethod patch(@Nonnull final AuthenticationMethod sourceAuthenticationMethod) throws ClientException {
        return send(HttpMethod.PATCH, sourceAuthenticationMethod);
    }

    /**
     * Creates a AuthenticationMethod with a new object
     *
     * @param newAuthenticationMethod the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationMethod> postAsync(@Nonnull final AuthenticationMethod newAuthenticationMethod) {
        return sendAsync(HttpMethod.POST, newAuthenticationMethod);
    }

    /**
     * Creates a AuthenticationMethod with a new object
     *
     * @param newAuthenticationMethod the new object to create
     * @return the created AuthenticationMethod
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AuthenticationMethod post(@Nonnull final AuthenticationMethod newAuthenticationMethod) throws ClientException {
        return send(HttpMethod.POST, newAuthenticationMethod);
    }

    /**
     * Creates a AuthenticationMethod with a new object
     *
     * @param newAuthenticationMethod the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationMethod> putAsync(@Nonnull final AuthenticationMethod newAuthenticationMethod) {
        return sendAsync(HttpMethod.PUT, newAuthenticationMethod);
    }

    /**
     * Creates a AuthenticationMethod with a new object
     *
     * @param newAuthenticationMethod the object to create/update
     * @return the created AuthenticationMethod
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AuthenticationMethod put(@Nonnull final AuthenticationMethod newAuthenticationMethod) throws ClientException {
        return send(HttpMethod.PUT, newAuthenticationMethod);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AuthenticationMethodRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AuthenticationMethodRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

