// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.BuiltInIdentityProvider;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Built In Identity Provider Request.
 */
public class BuiltInIdentityProviderRequest extends BaseRequest<BuiltInIdentityProvider> {
	
    /**
     * The request for the BuiltInIdentityProvider
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public BuiltInIdentityProviderRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, BuiltInIdentityProvider.class);
    }

    /**
     * Gets the BuiltInIdentityProvider from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BuiltInIdentityProvider> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the BuiltInIdentityProvider from the service
     *
     * @return the BuiltInIdentityProvider from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BuiltInIdentityProvider get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BuiltInIdentityProvider> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public BuiltInIdentityProvider delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this BuiltInIdentityProvider with a source
     *
     * @param sourceBuiltInIdentityProvider the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BuiltInIdentityProvider> patchAsync(@Nonnull final BuiltInIdentityProvider sourceBuiltInIdentityProvider) {
        return sendAsync(HttpMethod.PATCH, sourceBuiltInIdentityProvider);
    }

    /**
     * Patches this BuiltInIdentityProvider with a source
     *
     * @param sourceBuiltInIdentityProvider the source object with updates
     * @return the updated BuiltInIdentityProvider
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BuiltInIdentityProvider patch(@Nonnull final BuiltInIdentityProvider sourceBuiltInIdentityProvider) throws ClientException {
        return send(HttpMethod.PATCH, sourceBuiltInIdentityProvider);
    }

    /**
     * Creates a BuiltInIdentityProvider with a new object
     *
     * @param newBuiltInIdentityProvider the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BuiltInIdentityProvider> postAsync(@Nonnull final BuiltInIdentityProvider newBuiltInIdentityProvider) {
        return sendAsync(HttpMethod.POST, newBuiltInIdentityProvider);
    }

    /**
     * Creates a BuiltInIdentityProvider with a new object
     *
     * @param newBuiltInIdentityProvider the new object to create
     * @return the created BuiltInIdentityProvider
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BuiltInIdentityProvider post(@Nonnull final BuiltInIdentityProvider newBuiltInIdentityProvider) throws ClientException {
        return send(HttpMethod.POST, newBuiltInIdentityProvider);
    }

    /**
     * Creates a BuiltInIdentityProvider with a new object
     *
     * @param newBuiltInIdentityProvider the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BuiltInIdentityProvider> putAsync(@Nonnull final BuiltInIdentityProvider newBuiltInIdentityProvider) {
        return sendAsync(HttpMethod.PUT, newBuiltInIdentityProvider);
    }

    /**
     * Creates a BuiltInIdentityProvider with a new object
     *
     * @param newBuiltInIdentityProvider the object to create/update
     * @return the created BuiltInIdentityProvider
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BuiltInIdentityProvider put(@Nonnull final BuiltInIdentityProvider newBuiltInIdentityProvider) throws ClientException {
        return send(HttpMethod.PUT, newBuiltInIdentityProvider);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public BuiltInIdentityProviderRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public BuiltInIdentityProviderRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

