// Template Source: BaseMethodCollectionPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.DateTimeTimeZone;
import com.microsoft.graph.models.ScheduleInformation;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.requests.CalendarGetScheduleCollectionRequestBuilder;
import com.microsoft.graph.requests.CalendarGetScheduleCollectionPage;
import com.microsoft.graph.requests.CalendarGetScheduleCollectionResponse;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Calendar Get Schedule Collection Page.
 */
public class CalendarGetScheduleCollectionPage extends BaseCollectionPage<ScheduleInformation, CalendarGetScheduleCollectionRequestBuilder> {

    /**
     * A collection page for ScheduleInformation.
     *
     * @param response The serialized CalendarGetScheduleCollectionResponse from the service
     * @param builder The request builder for the next collection page
     */
    public CalendarGetScheduleCollectionPage(@Nonnull final CalendarGetScheduleCollectionResponse response, @Nonnull final CalendarGetScheduleCollectionRequestBuilder builder) {
       super(response, builder);
    }

	/**
     * Creates the collection page for CalendarGetSchedule
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public CalendarGetScheduleCollectionPage(@Nonnull final java.util.List<ScheduleInformation> pageContents, @Nullable final CalendarGetScheduleCollectionRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
