// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.ContentTypeAddCopyRequest;
import com.microsoft.graph.models.ContentType;
import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.models.ContentTypeAddCopyParameterSet;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Content Type Add Copy Request Builder.
 */
public class ContentTypeAddCopyRequestBuilder extends BaseActionRequestBuilder<ContentType> {

    /**
     * The request builder for this ContentTypeAddCopy
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ContentTypeAddCopyRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }
    private ContentTypeAddCopyParameterSet body;
    /**
     * The request builder for this ContentTypeAddCopy
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public ContentTypeAddCopyRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final ContentTypeAddCopyParameterSet parameters) {
        super(requestUrl, client, requestOptions);
        this.body = parameters;
    }

    /**
     * Creates the ContentTypeAddCopyRequest
     *
     * @param requestOptions the options for the request
     * @return the ContentTypeAddCopyRequest instance
     */
    @Nonnull
    public ContentTypeAddCopyRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the ContentTypeAddCopyRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the ContentTypeAddCopyRequest instance
     */
    @Nonnull
    public ContentTypeAddCopyRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final ContentTypeAddCopyRequest request = new ContentTypeAddCopyRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        request.body = this.body;
        return request;
    }
}
