// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.DeviceConfigurationDeviceOverview;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Configuration Device Overview Request.
 */
public class DeviceConfigurationDeviceOverviewRequest extends BaseRequest<DeviceConfigurationDeviceOverview> {
	
    /**
     * The request for the DeviceConfigurationDeviceOverview
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DeviceConfigurationDeviceOverviewRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceConfigurationDeviceOverview.class);
    }

    /**
     * Gets the DeviceConfigurationDeviceOverview from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceConfigurationDeviceOverview> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the DeviceConfigurationDeviceOverview from the service
     *
     * @return the DeviceConfigurationDeviceOverview from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceConfigurationDeviceOverview get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceConfigurationDeviceOverview> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public DeviceConfigurationDeviceOverview delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this DeviceConfigurationDeviceOverview with a source
     *
     * @param sourceDeviceConfigurationDeviceOverview the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceConfigurationDeviceOverview> patchAsync(@Nonnull final DeviceConfigurationDeviceOverview sourceDeviceConfigurationDeviceOverview) {
        return sendAsync(HttpMethod.PATCH, sourceDeviceConfigurationDeviceOverview);
    }

    /**
     * Patches this DeviceConfigurationDeviceOverview with a source
     *
     * @param sourceDeviceConfigurationDeviceOverview the source object with updates
     * @return the updated DeviceConfigurationDeviceOverview
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceConfigurationDeviceOverview patch(@Nonnull final DeviceConfigurationDeviceOverview sourceDeviceConfigurationDeviceOverview) throws ClientException {
        return send(HttpMethod.PATCH, sourceDeviceConfigurationDeviceOverview);
    }

    /**
     * Creates a DeviceConfigurationDeviceOverview with a new object
     *
     * @param newDeviceConfigurationDeviceOverview the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceConfigurationDeviceOverview> postAsync(@Nonnull final DeviceConfigurationDeviceOverview newDeviceConfigurationDeviceOverview) {
        return sendAsync(HttpMethod.POST, newDeviceConfigurationDeviceOverview);
    }

    /**
     * Creates a DeviceConfigurationDeviceOverview with a new object
     *
     * @param newDeviceConfigurationDeviceOverview the new object to create
     * @return the created DeviceConfigurationDeviceOverview
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceConfigurationDeviceOverview post(@Nonnull final DeviceConfigurationDeviceOverview newDeviceConfigurationDeviceOverview) throws ClientException {
        return send(HttpMethod.POST, newDeviceConfigurationDeviceOverview);
    }

    /**
     * Creates a DeviceConfigurationDeviceOverview with a new object
     *
     * @param newDeviceConfigurationDeviceOverview the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceConfigurationDeviceOverview> putAsync(@Nonnull final DeviceConfigurationDeviceOverview newDeviceConfigurationDeviceOverview) {
        return sendAsync(HttpMethod.PUT, newDeviceConfigurationDeviceOverview);
    }

    /**
     * Creates a DeviceConfigurationDeviceOverview with a new object
     *
     * @param newDeviceConfigurationDeviceOverview the object to create/update
     * @return the created DeviceConfigurationDeviceOverview
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceConfigurationDeviceOverview put(@Nonnull final DeviceConfigurationDeviceOverview newDeviceConfigurationDeviceOverview) throws ClientException {
        return send(HttpMethod.PUT, newDeviceConfigurationDeviceOverview);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public DeviceConfigurationDeviceOverviewRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public DeviceConfigurationDeviceOverviewRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

